/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.micro.discovery.multipart;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.micro.discovery.InOut;
import io.vertx.up.uca.micro.discovery.multipart.Pipe;
import java.io.File;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class UploadPipe
implements Pipe<HttpResponse> {
    private static final Annal LOGGER = Annal.get(UploadPipe.class);
    private final transient RoutingContext context;
    private final transient ServiceReference reference;
    private final transient RequestOptions options;
    private final transient HttpServerRequest request;
    private final transient HttpServerResponse response;

    private UploadPipe(RoutingContext context, ServiceReference reference, RequestOptions options) {
        this.context = context;
        this.request = context.request();
        this.response = context.response();
        this.reference = reference;
        this.options = options;
    }

    public static UploadPipe create(RoutingContext context, ServiceReference reference, RequestOptions options) {
        return new UploadPipe(context, reference, options);
    }

    @Override
    public void doRequest(Handler<HttpResponse> handler) {
        if (HttpMethod.POST == this.request.method() && this.request.isExpectMultipart()) {
            FileUpload fileUpload = this.getFile();
            if (null == fileUpload) {
                InOut.sync500Error(this.getClass(), this.context, new RuntimeException("Upload file missing..."));
            } else {
                this.executeUpload(fileUpload, handler);
            }
        } else {
            InOut.sync405Error(this.getClass(), this.context);
        }
    }

    private void executeUpload(FileUpload fileUpload, Handler<HttpResponse> handler) {
        try {
            String filename = fileUpload.uploadedFileName();
            File file = new File(filename);
            if (file.exists()) {
                CloseableHttpClient client = HttpClients.createDefault();
                String uri = this.remoteUri();
                HttpPost post = new HttpPost(uri);
                this.processHeaders(post);
                this.processMultipart(post, fileUpload, file);
                for (Header header : post.getAllHeaders()) {
                    LOGGER.info("Normalized header: key = {0}, value = {1}.", new Object[]{header.getName(), header.getValue()});
                }
                CloseableHttpResponse data = client.execute((HttpUriRequest)post);
                handler.handle((Object)data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InOut.sync500Error(this.getClass(), this.context, ex);
        }
    }

    private String remoteUri() {
        String uri = InOut.normalizeUri(this.context);
        StringBuilder absoluteUri = new StringBuilder();
        absoluteUri.append("http://").append(this.options.getHost());
        absoluteUri.append(":").append(this.options.getPort());
        absoluteUri.append(uri);
        String remoteUri = absoluteUri.toString();
        LOGGER.info("Multipart redirect uri: {0}", new Object[]{remoteUri});
        return remoteUri;
    }

    private void processMultipart(HttpPost request, FileUpload fileUpload, File file) {
        ContentType contentType = ContentType.create((String)fileUpload.contentType());
        LOGGER.info("Read file from file system: {0}", new Object[]{file.getAbsolutePath()});
        FileBody fileBody = new FileBody(file, contentType);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        String disposition = "form-data; name=\"file\"; filename=\"" + fileUpload.fileName();
        FormBodyPart bodyPart = FormBodyPartBuilder.create().setName("file").addField("Content-Type", fileUpload.contentType()).addField("Content-Transfer-Encoding", fileUpload.contentTransferEncoding()).addField("Content-Disposition", disposition).setBody((ContentBody)fileBody).build();
        builder.addPart(bodyPart);
        HttpEntity entity = builder.build();
        request.setEntity(entity);
    }

    private void processHeaders(HttpPost request) {
        this.request.headers().forEach(entry -> LOGGER.info("Client header: {0} = {1}", new Object[]{entry.getKey(), entry.getValue()}));
        this.processHeader(request, HttpHeaders.AUTHORIZATION);
        this.processHeader(request, HttpHeaders.CACHE_CONTROL);
        this.processHeader(request, HttpHeaders.ACCEPT);
        this.processHeader(request, HttpHeaders.CONNECTION);
        this.processHeader(request, HttpHeaders.ACCEPT_ENCODING);
    }

    private void processHeader(HttpPost request, CharSequence key) {
        if (this.request.headers().contains(key)) {
            request.setHeader(key.toString(), this.request.headers().get(key));
        }
    }

    private FileUpload getFile() {
        Set fileUploads = this.context.fileUploads();
        if (fileUploads.isEmpty()) {
            return null;
        }
        return (FileUpload)fileUploads.iterator().next();
    }
}

