/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.micro.discovery;

import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientSession;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.micro.discovery.InOut;
import io.vertx.up.uca.micro.discovery.multipart.UploadPipe;
import io.vertx.up.uca.micro.matcher.Arithmetic;
import io.vertx.up.uca.micro.matcher.CommonArithmetic;
import io.vertx.up.uca.options.CircuitVisitor;
import io.vertx.up.uca.options.Visitor;
import io.vertx.up.uca.registry.UddiJet;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.function.Consumer;

public class ServiceJet
implements UddiJet {
    private static final Annal LOGGER = Annal.get(ServiceJet.class);
    private static final Visitor<CircuitBreakerOptions> VISITOR = (Visitor)Ut.singleton(CircuitVisitor.class, (Object[])new Object[0]);
    private static CircuitBreakerOptions OPTIONS;
    private final transient Arithmetic arithmetic = (Arithmetic)Ut.singleton(CommonArithmetic.class, (Object[])new Object[0]);
    private transient HttpServerOptions options;
    private transient ServiceDiscovery discovery;
    private transient CircuitBreaker breaker;

    public UddiJet bind(HttpServerOptions options) {
        this.options = options;
        return this;
    }

    public UddiJet bind(Vertx vertx) {
        this.discovery = ServiceDiscovery.create((Vertx)vertx);
        String name = this.options.getHost() + this.options.getPort();
        this.breaker = CircuitBreaker.create((String)name, (Vertx)vertx, (CircuitBreakerOptions)OPTIONS);
        return this;
    }

    private Future<List<Record>> getEndPoints() {
        Promise promise = Promise.promise();
        this.discovery.getRecords(record -> record.getType().equals("http-endpoint"), handler -> promise.complete((Object)((List)handler.result())));
        return promise.future();
    }

    public Handler<RoutingContext> handler() {
        return context -> this.breaker.execute(future -> this.getEndPoints().onComplete(res -> {
            if (res.succeeded()) {
                List records = (List)res.result();
                Record hitted = this.arithmetic.search(records, (RoutingContext)context);
                if (null == hitted) {
                    InOut.sync404Error(this.getClass(), context);
                    future.complete();
                } else {
                    ServiceReference reference = this.discovery.getReference(hitted);
                    Consumer<Void> consumer = nil -> {
                        reference.release();
                        future.complete();
                    };
                    this.doRequest((RoutingContext)context, reference, hitted, consumer);
                }
            } else {
                future.fail(res.cause());
            }
        }));
    }

    private void doRequest(RoutingContext context, ServiceReference reference, Record record, Consumer<Void> consumer) {
        HttpServerRequest rctRequest = context.request();
        HttpMethod method = rctRequest.method();
        String uri = InOut.normalizeUri(context);
        WebClient client = (WebClient)reference.getAs(WebClient.class);
        WebClientSession session = WebClientSession.create((WebClient)client);
        RequestOptions options = InOut.getOptions(record, uri);
        HttpRequest request = session.request(method, options);
        MultiMap headers = rctRequest.headers();
        headers.forEach(item -> request.putHeader((String)item.getKey(), (String)item.getValue()));
        request.timeout(30000L);
        if (rctRequest.isExpectMultipart()) {
            UploadPipe pump = UploadPipe.create(context, reference, options);
            pump.doRequest(InOut.replyHttp(this.getClass(), context, consumer));
        } else {
            Buffer body = context.getBody();
            if (null == body) {
                body = Buffer.buffer();
            }
            request.sendBuffer(body, InOut.replyWeb(this.getClass(), context, consumer));
        }
    }

    static {
        Fn.outUp(() -> {
            if (null == OPTIONS) {
                OPTIONS = (CircuitBreakerOptions)VISITOR.visit(new String[0]);
            }
        }, (Annal)LOGGER);
    }
}

