/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.micro.discovery;

import io.reactivex.Observable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.types.HttpEndpoint;
import io.vertx.up.eon.em.EtcdPath;
import io.vertx.up.uca.micro.center.ZeroRegistry;
import io.vertx.up.uca.micro.discovery.Origin;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ApiOrigin
implements Origin {
    private final transient ZeroRegistry registry = ZeroRegistry.create(this.getClass());

    @Override
    public ConcurrentMap<String, Record> getRegistryData() {
        return this.readData(EtcdPath.ENDPOINT);
    }

    @Override
    public boolean erasing(Record record) {
        String host = record.getLocation().getString("host");
        Integer port = record.getLocation().getInteger("port");
        String name = record.getName();
        if (!Ut.netOk((String)host, (int)port)) {
            this.registry.erasingStatus(name, host, port, this.getPath());
        }
        return true;
    }

    protected EtcdPath getPath() {
        return EtcdPath.ENDPOINT;
    }

    ConcurrentMap<String, Record> readData(EtcdPath path) {
        Set<String> results = this.registry.getServices(path);
        HashSet routes = new HashSet();
        Observable.fromIterable(results).map(key -> this.registry.getData(path, (String)key, this::getItem)).subscribe(routes::addAll).dispose();
        ConcurrentHashMap<String, Record> map = new ConcurrentHashMap<String, Record>();
        Observable.fromIterable(routes).subscribe(item -> {
            String key = item.getJsonObject("metadata").getString("id");
            Record record = this.createRecord((JsonObject)item);
            map.put(key, record);
        }).dispose();
        return map;
    }

    private Record createRecord(JsonObject item) {
        String name = item.getString("name");
        String host = item.getString("host");
        Integer port = item.getInteger("port");
        JsonObject meta = item.getJsonObject("metadata");
        return HttpEndpoint.createRecord((String)name, (String)host, (int)port, (String)"/*", (JsonObject)meta);
    }

    private Set<JsonObject> getItem(String key, JsonArray value) {
        HashSet<JsonObject> sets = new HashSet<JsonObject>();
        String[] meta = key.split(":");
        if (3 == meta.length) {
            Observable.fromIterable((Iterable)value).filter(Objects::nonNull).map(Object::toString).map(item -> {
                String name = meta[0];
                String host = meta[1];
                String port = meta[2];
                String id = Ut.encryptSHA256((String)(key + item));
                return new JsonObject().put("name", (Object)name).put("host", (Object)host).put("port", (Object)Integer.parseInt(port)).put("metadata", (Object)new JsonObject().put("id", (Object)id).put("path", item));
            }).subscribe(sets::add).dispose();
        }
        return sets;
    }
}

