/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ipc.service;

import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.stub.ClientCalls;
import io.vertx.tp.ipc.eon.StreamClientRequest;
import io.vertx.tp.ipc.eon.StreamServerResponse;
import io.vertx.tp.ipc.service.DupliexServiceGrpc;

public final class VertxDupliexServiceGrpc {
    private static final int METHODID_DUPLIEX_CALL = 0;

    private VertxDupliexServiceGrpc() {
    }

    public static DupliexServiceVertxStub newVertxStub(Channel channel) {
        return new DupliexServiceVertxStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final DupliexServiceVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(DupliexServiceVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return io.vertx.grpc.stub.ServerCalls.manyToMany(responseObserver, (String)this.compression, this.serviceImpl::dupliexCall);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class DupliexServiceVertxImplBase
    implements BindableService {
        private String compression;

        public DupliexServiceVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public void dupliexCall(ReadStream<StreamClientRequest> request, WriteStream<StreamServerResponse> response) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)DupliexServiceGrpc.getServiceDescriptor()).addMethod(DupliexServiceGrpc.METHOD_DUPLIEX_CALL, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 0, this.compression))).build();
        }
    }

    public static final class DupliexServiceVertxStub
    extends AbstractStub<DupliexServiceVertxStub> {
        private final ContextInternal ctx;
        private DupliexServiceGrpc.DupliexServiceStub delegateStub;

        private DupliexServiceVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = DupliexServiceGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private DupliexServiceVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = DupliexServiceGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        protected DupliexServiceVertxStub build(Channel channel, CallOptions callOptions) {
            return new DupliexServiceVertxStub(channel, callOptions);
        }

        public ReadStream<StreamServerResponse> dupliexCall(Handler<WriteStream<StreamClientRequest>> hdlr) {
            return ClientCalls.manyToMany((ContextInternal)this.ctx, hdlr, this.delegateStub::dupliexCall);
        }
    }
}

