/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell.atom;

import com.fasterxml.jackson.databind.ClassDeserializer;
import com.fasterxml.jackson.databind.ClassSerializer;
import com.fasterxml.jackson.databind.JsonObjectDeserializer;
import com.fasterxml.jackson.databind.JsonObjectSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.shell.Commander;
import io.vertx.tp.plugin.shell.atom.CommandOption;
import io.vertx.tp.plugin.shell.cv.em.CommandType;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.cli.Options;

public class CommandAtom
implements Serializable {
    private transient CommandType type = CommandType.COMMAND;
    private transient String simple;
    private transient String name;
    private transient String description;
    private transient boolean args;
    @JsonSerialize(using=ClassSerializer.class)
    @JsonDeserialize(using=ClassDeserializer.class)
    private transient Class<?> plugin;
    private transient List<CommandAtom> commands = new ArrayList<CommandAtom>();
    private transient List<CommandOption> options = new ArrayList<CommandOption>();
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private transient JsonObject config = new JsonObject();

    public String getSimple() {
        return this.simple;
    }

    public void setSimple(String simple) {
        this.simple = simple;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Class<?> getPlugin() {
        return this.plugin;
    }

    public void setPlugin(Class<?> plugin) {
        this.plugin = plugin;
    }

    public CommandType getType() {
        return this.type;
    }

    public void setType(CommandType type) {
        this.type = type;
    }

    public List<CommandOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<CommandOption> options) {
        this.options = options;
    }

    public List<String> getOptionNames() {
        return this.options.stream().map(CommandOption::getName).collect(Collectors.toList());
    }

    public List<CommandAtom> getCommands() {
        return this.commands;
    }

    public void setCommands(List<CommandAtom> commands) {
        this.commands = commands;
    }

    public boolean isArgs() {
        return this.args;
    }

    public void setArgs(boolean args) {
        this.args = args;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public void setConfig(JsonObject config) {
        this.config = config;
    }

    public boolean valid() {
        if (CommandType.COMMAND == this.type) {
            if (Objects.isNull(this.plugin)) {
                return false;
            }
            return Ut.isImplement(this.plugin, Commander.class);
        }
        return true;
    }

    public <T> T getDefault(String simple) {
        CommandOption option = this.options.stream().filter(each -> simple.equals(each.getSimple())).findAny().orElse(null);
        if (Objects.isNull(option)) {
            return null;
        }
        if (option.isRequired()) {
            return null;
        }
        return (T)option.getDefaultValue();
    }

    public Options options() {
        Options options = new Options();
        this.options.stream().map(CommandOption::option).forEach(arg_0 -> ((Options)options).addOption(arg_0));
        return options;
    }

    public CommandOption option(String name) {
        return this.options.stream().filter(item -> name.equals(item.getSimple())).findAny().orElse(null);
    }
}

