/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell.atom;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.tp.error.CommandMissingException;
import io.vertx.up.exception.UpException;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Terminal {
    private static final transient UpException ERROR_ARG_MISSING = new CommandMissingException(Terminal.class);
    private static final ConcurrentMap<Integer, Scanner> POOL_SCANNER = new ConcurrentHashMap<Integer, Scanner>();
    private final transient Scanner scanner;
    private final transient Vertx vertx;
    private final transient List<String> inputHistory = new ArrayList<String>();

    private Terminal(Vertx vertx) {
        this.vertx = vertx;
        this.scanner = (Scanner)Fn.pool(POOL_SCANNER, (Object)vertx.hashCode(), () -> new Scanner(System.in));
        this.scanner.useDelimiter("\n");
    }

    public static Terminal create(Vertx vertx) {
        return new Terminal(vertx);
    }

    public void run(Handler<AsyncResult<String[]>> handler) {
        try {
            if (this.scanner.hasNextLine()) {
                this.runLine(handler);
            } else {
                POOL_SCANNER.values().forEach(scanner -> Fn.safeJvm(scanner::close));
                System.exit(0);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            this.runLine(handler);
        }
    }

    private void runLine(Handler<AsyncResult<String[]>> handler) {
        String line = this.scanner.nextLine();
        if (Ut.isNil((String)line)) {
            handler.handle((Object)Future.failedFuture((Throwable)ERROR_ARG_MISSING));
        } else {
            this.inputHistory.add(line);
            String[] normalized = this.arguments(line);
            handler.handle((Object)Future.succeededFuture((Object)normalized));
        }
    }

    private String[] arguments(String line) {
        String[] interactArgs = line.split(" ");
        String[] normalized = 0 < interactArgs.length ? (String[])Arrays.stream(interactArgs).map(String::trim).toArray(String[]::new) : interactArgs;
        return normalized;
    }
}

