/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.neo4j.sync;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.neo4j.AbstractN4JSession;
import io.vertx.tp.plugin.neo4j.refine.N4J;
import io.vertx.tp.plugin.neo4j.sync.N4JOp;
import io.vertx.tp.plugin.neo4j.sync.N4JOpEdge;
import io.vertx.tp.plugin.neo4j.sync.N4JOpNode;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.neo4j.driver.Session;

public class N4JSession
extends AbstractN4JSession {
    private transient N4JOp nodeOp;
    private transient N4JOp edgeOp;

    public N4JSession(String graph) {
        super(graph);
    }

    private N4JOp nodeOp() {
        if (Objects.isNull(this.nodeOp)) {
            this.nodeOp = new N4JOpNode(this.graph, this.driver);
        }
        return this.nodeOp;
    }

    private N4JOp edgeOp() {
        if (Objects.isNull(this.edgeOp)) {
            this.edgeOp = new N4JOpEdge(this.graph, this.driver);
        }
        return this.edgeOp;
    }

    @Override
    public Future<JsonObject> create(JsonObject node) {
        return this.nodeOp().create(node);
    }

    @Override
    public Future<JsonArray> create(JsonArray nodes) {
        return this.nodeOp().create(nodes);
    }

    @Override
    public Future<JsonObject> update(JsonObject node) {
        return this.nodeOp().update(node);
    }

    @Override
    public Future<JsonArray> update(JsonArray nodes) {
        return this.nodeOp().update(nodes);
    }

    @Override
    public Future<JsonObject> delete(JsonObject node) {
        return this.nodeOp().delete(node);
    }

    @Override
    public Future<JsonArray> delete(JsonArray nodes) {
        return this.nodeOp().delete(nodes);
    }

    @Override
    public Future<JsonObject> find(JsonObject condition) {
        return this.doAsync(condition, "found", (JsonObject processed) -> N4J.nodeFind(this.graph, processed, "found"));
    }

    @Override
    public JsonObject findSync(JsonObject condition) {
        return this.doSync(condition, "found", processed -> N4J.nodeFind(this.graph, processed, "found"));
    }

    @Override
    public Future<JsonObject> link(JsonObject edge) {
        return this.edgeOp().create(edge);
    }

    @Override
    public Future<JsonArray> link(JsonArray edges) {
        return this.edgeOp().create(edges);
    }

    @Override
    public Future<JsonObject> relink(JsonObject edge) {
        return this.edgeOp().update(edge);
    }

    @Override
    public Future<JsonArray> relink(JsonArray edges) {
        return this.edgeOp().update(edges);
    }

    @Override
    public Future<JsonObject> unlink(JsonObject edge) {
        return this.edgeOp().delete(edge);
    }

    @Override
    public Future<JsonArray> unlink(JsonArray edges) {
        return this.edgeOp().delete(edges);
    }

    @Override
    public void constraints() {
        this.execute(() -> N4J.constraint(this.graph, (Set<String>)new HashSet<String>(){
            {
                this.add("key");
            }
        }, "constraints"));
    }

    @Override
    public Future<Boolean> reset() {
        this.execute(() -> {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(N4J.graphicReset(this.graph));
            return commands;
        });
        return Ux.future((Object)Boolean.TRUE);
    }

    @Override
    protected Session session() {
        return this.driver.session();
    }
}

