/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.neo4j.sync;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.neo4j.refine.N4J;
import io.vertx.tp.plugin.neo4j.sync.AbstractN4JExecutor;
import io.vertx.tp.plugin.neo4j.sync.N4JOp;
import io.vertx.up.util.Ut;
import java.util.Objects;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;

public class N4JOpEdge
extends AbstractN4JExecutor
implements N4JOp {
    private final transient String graph;
    private final transient Driver driver;

    N4JOpEdge(String graph, Driver driver) {
        this.graph = graph;
        this.driver = driver;
    }

    @Override
    public Future<JsonObject> create(JsonObject node) {
        return this.doAsync(node, (JsonObject processed) -> N4J.edgeFind(this.graph, processed)).compose(result -> {
            if (Ut.isNil((JsonObject)result)) {
                return this.doAsync(node, (JsonObject processed) -> N4J.edgeAdd(this.graph, processed));
            }
            N4J.warnEdge(this.getClass(), "Existing of {0}, Skip", node.encode());
            return Future.succeededFuture((Object)node);
        });
    }

    @Override
    public Future<JsonArray> create(JsonArray nodes) {
        return this.doAsync(nodes, (JsonArray processed) -> N4J.edgeFind(this.graph, nodes)).compose(result -> {
            JsonArray added = new JsonArray();
            JsonArray ignored = new JsonArray();
            for (int idx = 0; idx < nodes.size(); ++idx) {
                JsonObject item = result.getJsonObject(idx);
                if (Objects.isNull(item)) {
                    added.add(nodes.getValue(idx));
                    continue;
                }
                ignored.add(nodes.getValue(idx));
            }
            if (!ignored.isEmpty()) {
                N4J.warnEdge(this.getClass(), "Existing of {0}, Skip", ignored.encode());
            }
            if (added.isEmpty()) {
                return Future.succeededFuture((Object)nodes);
            }
            return this.doAsync(added, (JsonArray processed) -> N4J.edgeAdd(this.graph, processed)).compose(created -> Future.succeededFuture((Object)nodes));
        });
    }

    @Override
    public Future<JsonObject> update(JsonObject node) {
        return this.doAsync(node, (JsonObject processed) -> N4J.edgeDelete(this.graph, processed)).compose(nil -> this.doAsync(node, (JsonObject processed) -> N4J.edgeAdd(this.graph, processed)));
    }

    @Override
    public Future<JsonArray> update(JsonArray nodes) {
        return this.doAsync(nodes, (JsonArray processed) -> N4J.edgeDelete(this.graph, processed)).compose(nil -> this.doAsync(nodes, (JsonArray processed) -> N4J.edgeAdd(this.graph, processed)));
    }

    @Override
    public Future<JsonObject> delete(JsonObject node) {
        return this.doAsync(node, (JsonObject processed) -> N4J.edgeDelete(this.graph, processed));
    }

    @Override
    public Future<JsonArray> delete(JsonArray nodes) {
        return this.doAsync(nodes, (JsonArray processed) -> N4J.edgeDelete(this.graph, processed));
    }

    @Override
    protected Session session() {
        return this.driver.session();
    }
}

