/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.neo4j.sync;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.neo4j.refine.N4J;
import io.vertx.up.util.Ut;
import java.util.List;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.exceptions.ClientException;

class N4JExecutor {
    private transient Session session;

    private N4JExecutor() {
    }

    static N4JExecutor create() {
        return new N4JExecutor();
    }

    N4JExecutor bind(Session session) {
        this.session = session;
        return this;
    }

    JsonObject execute(String command, JsonObject params, String alias) {
        Transaction transaction = this.session.beginTransaction();
        JsonObject result = Ut.isNil((String)alias) ? N4J.toJson(transaction.run(command, N4J.parameters(params))) : N4J.toJson(transaction.run(command, N4J.parameters(params)), alias);
        transaction.commit();
        transaction.close();
        this.session.close();
        return result;
    }

    JsonObject execute(String command, JsonObject params) {
        return this.execute(command, params, null);
    }

    JsonArray execute(List<String> command, JsonArray params) {
        return this.execute(command, params, null);
    }

    JsonArray execute(List<String> commands, JsonArray params, String alias) {
        JsonArray response = new JsonArray();
        Transaction transaction = this.session.beginTransaction();
        Ut.itList(commands, (command, index) -> {
            JsonObject item = params.getJsonObject(index.intValue());
            JsonObject result = Ut.isNil((String)alias) ? N4J.toJson(transaction.run(command, N4J.parameters(item))) : N4J.toJson(transaction.run(command, N4J.parameters(item)), alias);
            response.add(result);
        });
        transaction.commit();
        transaction.close();
        this.session.close();
        return response;
    }

    void execute(List<String> commands) {
        try {
            Transaction transaction = this.session.beginTransaction();
            commands.forEach(command -> {
                N4J.infoCql(N4JExecutor.class, "Each Command: {0}", command);
                transaction.run(command);
            });
            transaction.commit();
            transaction.close();
            this.session.close();
        }
        catch (ClientException ex) {
            N4J.warnCql(N4JExecutor.class, "ClientException: {0}", ex.getMessage());
        }
    }
}

