/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.neo4j.refine;

import io.vertx.core.json.JsonObject;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.Map;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalRelationship;

class N4JOutput {
    private static final Annal LOGGER = Annal.get(N4JOutput.class);

    N4JOutput() {
    }

    static JsonObject toJson(Result result) {
        try {
            if (result.hasNext()) {
                return N4JOutput.toJson(result.single());
            }
            return null;
        }
        catch (NoSuchRecordException ex) {
            LOGGER.warn("[ NEO4J ] Edge Exception: {0}", new Object[]{ex.getMessage()});
            return null;
        }
    }

    static JsonObject toJson(Result result, String alias) {
        try {
            if (result.hasNext()) {
                Record record = result.single();
                JsonObject data = N4JOutput.toJson(record);
                JsonObject normalized = new JsonObject();
                Ut.itJObject((JsonObject)data, (value, field) -> {
                    if (field.contains(alias)) {
                        normalized.put(field.replace(alias + ".", ""), value);
                    } else {
                        normalized.put(field, value);
                    }
                });
                return normalized;
            }
            return null;
        }
        catch (NoSuchRecordException ex) {
            LOGGER.warn("[ NEO4J ] Node Exception: {0}", new Object[]{ex.getMessage()});
            return null;
        }
    }

    private static JsonObject toJson(Record record) {
        return N4JOutput.toJson(record.asMap());
    }

    static JsonObject toJson(Map<String, Object> input) {
        JsonObject data = new JsonObject();
        input.forEach((key, value) -> {
            if (value instanceof InternalNode) {
                InternalNode node = (InternalNode)value;
                node.asMap().forEach((arg_0, arg_1) -> ((JsonObject)data).put(arg_0, arg_1));
            } else if (value instanceof InternalRelationship) {
                InternalRelationship edge = (InternalRelationship)value;
                edge.asMap().forEach((arg_0, arg_1) -> ((JsonObject)data).put(arg_0, arg_1));
            } else {
                data.put(key, value);
            }
        });
        return data;
    }
}

