/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.neo4j.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.neo4j.refine.N4J;
import io.vertx.tp.plugin.neo4j.refine.N4JCond;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class N4JNode {
    N4JNode() {
    }

    static List<String> add(String graph, JsonArray node, String alias) {
        ArrayList<String> commands = new ArrayList<String>();
        Ut.itJArray((JsonArray)node).map(item -> N4JNode.add(graph, item, alias)).forEach(commands::add);
        if (!commands.isEmpty()) {
            N4J.infoCql(N4JNode.class, "Add Command: {0}", commands.get(0));
        }
        return commands;
    }

    static String add(String graph, JsonObject node, String alias) {
        StringBuilder cql = new StringBuilder();
        cql.append("CREATE (").append(alias).append(":").append(graph).append(" ");
        cql.append("{");
        ArrayList<String> kv = new ArrayList<String>();
        node.fieldNames().forEach(field -> kv.add(field + ":$" + field));
        kv.add("createdAt:timestamp()");
        kv.add("updatedAt:timestamp()");
        cql.append(Ut.fromJoin(kv, (String)","));
        cql.append("})");
        cql.append(" RETURN ").append(alias);
        return cql.toString();
    }

    static List<String> update(String graph, JsonArray conditions, JsonArray data, String alias) {
        ArrayList<String> commands = new ArrayList<String>();
        Ut.itJArray((JsonArray)conditions, JsonObject.class, (item, index) -> commands.add(N4JNode.update(graph, item, data.getJsonObject(index.intValue()), alias)));
        if (!commands.isEmpty()) {
            N4J.infoCql(N4JNode.class, "Update Command: {0}", commands.get(0));
        }
        return commands;
    }

    static String update(String graph, JsonObject condition, JsonObject node, String alias) {
        StringBuilder cql = new StringBuilder();
        cql.append("MERGE ").append(N4JCond.graphCondition(graph, condition, alias));
        cql.append("ON MATCH SET ");
        ArrayList<String> set = new ArrayList<String>();
        Ut.itJObject((JsonObject)node, (value, field) -> set.add(alias + "." + field + "=$" + field));
        set.add(alias + ".updatedAt=timestamp()");
        cql.append(Ut.fromJoin(set, (String)","));
        cql.append(" RETURN ").append(alias);
        return cql.toString();
    }

    static List<String> delete(String graph, JsonArray conditions, String alias) {
        ArrayList<String> commands = new ArrayList<String>();
        Ut.itJArray((JsonArray)conditions, JsonObject.class, (item, index) -> commands.add(N4JNode.delete(graph, item, alias)));
        if (!commands.isEmpty()) {
            N4J.infoCql(N4JNode.class, "Delete Command: {0}", commands.get(0));
        }
        return commands;
    }

    static String delete(String graph, JsonObject condition, String alias) {
        StringBuilder cql = new StringBuilder();
        cql.append("MATCH ").append(N4JCond.graphCondition(graph, condition, alias));
        cql.append("DETACH DELETE ").append(alias);
        return cql.toString();
    }

    static String find(String graph, JsonObject condition, String alias) {
        StringBuilder cql = new StringBuilder();
        cql.append("MATCH (").append(alias).append(":").append(graph).append(") ");
        cql.append("WHERE ");
        ArrayList wheres = new ArrayList();
        Ut.itJObject((JsonObject)condition, (value, field) -> wheres.add(alias + "." + field + "=$" + field));
        cql.append(Ut.fromJoin(wheres, (String)" AND "));
        cql.append(" RETURN ").append(alias);
        return cql.toString();
    }

    static List<String> constraint(String graph, Set<String> properties, String alias) {
        ArrayList<String> kv = new ArrayList<String>();
        properties.forEach(property -> kv.add("CREATE CONSTRAINT ON (" + alias + ":" + graph + ") ASSERT " + alias + "." + property + " IS UNIQUE"));
        return kv;
    }
}

