/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.neo4j.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;

class N4JEdge {
    N4JEdge() {
    }

    static List<String> add(String graph, JsonArray edges) {
        ArrayList<String> commands = new ArrayList<String>();
        Ut.itJArray((JsonArray)edges).map(item -> N4JEdge.add(graph, item)).forEach(commands::add);
        return commands;
    }

    static String add(String graph, JsonObject edge) {
        StringBuilder cql = new StringBuilder();
        cql.append("MATCH (source:").append(graph).append("),");
        cql.append("(target:").append(graph).append(") ");
        cql.append("WHERE source.key").append(" = $source");
        cql.append(" AND target.key").append(" = $target");
        cql.append(" CREATE (source)-[relation:").append(edge.getValue("type")).append(" ");
        ArrayList kv = new ArrayList();
        edge.fieldNames().forEach(key -> kv.add(key + ":$" + key));
        cql.append("{").append(Ut.fromJoin(kv, (String)",")).append("}");
        cql.append("]->(target)");
        cql.append(" RETURN relation");
        return cql.toString();
    }

    static List<String> find(String graph, JsonArray edge) {
        ArrayList<String> commands = new ArrayList<String>();
        Ut.itJArray((JsonArray)edge).map(item -> N4JEdge.find(graph, item)).forEach(commands::add);
        return commands;
    }

    private static String findCond(String graph, JsonObject edge) {
        StringBuilder cql = new StringBuilder();
        cql.append("MATCH (source:").append(graph).append(" { key:$source })-");
        cql.append("[ r:").append(edge.getValue("type")).append(" ]->");
        cql.append("(target:").append(graph).append(" { key:$target })");
        return cql.toString();
    }

    static String find(String graph, JsonObject edge) {
        return N4JEdge.findCond(graph, edge) + " RETURN r";
    }

    static List<String> delete(String graph, JsonArray edges) {
        ArrayList<String> commands = new ArrayList<String>();
        Ut.itJArray((JsonArray)edges).map(item -> N4JEdge.delete(graph, item)).forEach(commands::add);
        return commands;
    }

    static String delete(String graph, JsonObject edge) {
        return N4JEdge.findCond(graph, edge) + " DELETE r";
    }
}

