/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.neo4j.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.neo4j.refine.N4JApoc;
import io.vertx.tp.plugin.neo4j.refine.N4JCond;
import io.vertx.tp.plugin.neo4j.refine.N4JEdge;
import io.vertx.tp.plugin.neo4j.refine.N4JInput;
import io.vertx.tp.plugin.neo4j.refine.N4JLog;
import io.vertx.tp.plugin.neo4j.refine.N4JNode;
import io.vertx.tp.plugin.neo4j.refine.N4JOutput;
import io.vertx.up.log.Annal;
import java.util.List;
import java.util.Set;
import org.neo4j.driver.Result;
import org.neo4j.driver.Value;

public class N4J {
    public static void infoNode(Class<?> clazz, String pattern, Object ... args) {
        Annal logger = Annal.get(clazz);
        N4JLog.info(logger, "Node", pattern, args);
    }

    public static void infoEdge(Class<?> clazz, String pattern, Object ... args) {
        Annal logger = Annal.get(clazz);
        N4JLog.info(logger, "Edge", pattern, args);
    }

    public static void debugEdge(Class<?> clazz, String pattern, Object ... args) {
        Annal logger = Annal.get(clazz);
        N4JLog.debug(logger, "Edge", pattern, args);
    }

    public static void warnEdge(Class<?> clazz, String pattern, Object ... args) {
        Annal logger = Annal.get(clazz);
        N4JLog.warn(logger, "Edge", pattern, args);
    }

    public static void infoCql(Class<?> clazz, String pattern, Object ... args) {
        Annal logger = Annal.get(clazz);
        N4JLog.info(logger, "Cql", pattern, args);
    }

    public static void warnCql(Class<?> clazz, String pattern, Object ... args) {
        Annal logger = Annal.get(clazz);
        N4JLog.warn(logger, "Cql", pattern, args);
    }

    public static List<String> constraint(String graph, Set<String> properties, String alias) {
        return N4JNode.constraint(graph, properties, alias);
    }

    public static String nodeAdd(String graph, JsonObject node, String alias) {
        return N4JNode.add(graph, node, alias);
    }

    public static List<String> nodeAdd(String graph, JsonArray node, String alias) {
        return N4JNode.add(graph, node, alias);
    }

    public static String nodeUpdate(String graph, JsonObject condition, JsonObject data, String alias) {
        return N4JNode.update(graph, condition, data, alias);
    }

    public static List<String> nodeUpdate(String graph, JsonArray conditions, JsonArray data, String alias) {
        return N4JNode.update(graph, conditions, data, alias);
    }

    public static String nodeDelete(String graph, JsonObject condition, String alias) {
        return N4JNode.delete(graph, condition, alias);
    }

    public static List<String> nodeDelete(String graph, JsonArray conditions, String alias) {
        return N4JNode.delete(graph, conditions, alias);
    }

    public static JsonObject nodeUnique(JsonObject data) {
        return N4JCond.nodeUnique(data);
    }

    public static JsonArray nodeUnique(JsonArray data) {
        return N4JCond.nodeUnique(data);
    }

    public static String nodeFind(String graph, JsonObject condition, String alias) {
        return N4JNode.find(graph, condition, alias);
    }

    public static String edgeAdd(String graph, JsonObject edge) {
        return N4JEdge.add(graph, edge);
    }

    public static List<String> edgeAdd(String graph, JsonArray node) {
        return N4JEdge.add(graph, node);
    }

    public static String edgeDelete(String graph, JsonObject edge) {
        return N4JEdge.delete(graph, edge);
    }

    public static List<String> edgeDelete(String graph, JsonArray edge) {
        return N4JEdge.delete(graph, edge);
    }

    public static String edgeFind(String graph, JsonObject edge) {
        return N4JEdge.find(graph, edge);
    }

    public static List<String> edgeFind(String graph, JsonArray edge) {
        return N4JEdge.find(graph, edge);
    }

    public static String graphicByKey(String graph, Integer level) {
        return N4JApoc.graphic(graph, level);
    }

    public static String graphicReset(String graph) {
        return N4JApoc.graphicReset(graph);
    }

    public static JsonObject nodeMarker(JsonObject node) {
        return N4JInput.marker(node);
    }

    public static JsonArray nodeMarker(JsonArray node) {
        return N4JInput.marker(node);
    }

    public static Value parameters(JsonObject input) {
        return N4JInput.parameters(input);
    }

    public static JsonObject toJson(Result result, String alias) {
        return N4JOutput.toJson(result, alias);
    }

    public static JsonObject toJson(Result result) {
        return N4JOutput.toJson(result);
    }

    public static JsonObject toJson(Value value) {
        return N4JOutput.toJson(value.asMap());
    }

    public static JsonObject graphicDefault() {
        return new JsonObject().put("nodes", new JsonArray()).put("edges", new JsonArray());
    }
}

