/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.neo4j.sync;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.neo4j.refine.N4J;
import io.vertx.tp.plugin.neo4j.sync.AbstractN4JExecutor;
import io.vertx.tp.plugin.neo4j.sync.N4JOp;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;

public class N4JOpNode
extends AbstractN4JExecutor
implements N4JOp {
    private final transient String graph;
    private final transient Driver driver;

    N4JOpNode(String graph, Driver driver) {
        this.graph = graph;
        this.driver = driver;
    }

    @Override
    public Future<JsonObject> create(JsonObject node) {
        return this.doAsync(N4J.nodeMarker(node), "created", (JsonObject processed) -> N4J.nodeAdd(this.graph, processed, "created"));
    }

    @Override
    public Future<JsonArray> create(JsonArray nodes) {
        return this.doAsync(N4J.nodeMarker(nodes), "created", (JsonArray processed) -> N4J.nodeAdd(this.graph, processed, "created"));
    }

    @Override
    public Future<JsonObject> update(JsonObject node) {
        return this.doAsync(N4J.nodeMarker(node), "updated", (JsonObject processed) -> N4J.nodeUpdate(this.graph, this.unique(node), processed, "updated"));
    }

    @Override
    public Future<JsonArray> update(JsonArray nodes) {
        return this.doAsync(N4J.nodeMarker(nodes), "updated", (JsonArray processed) -> N4J.nodeUpdate(this.graph, this.unique(nodes), processed, "updated"));
    }

    @Override
    public Future<JsonObject> delete(JsonObject node) {
        return this.doAsync(N4J.nodeUnique(node), "deleted", (JsonObject processed) -> N4J.nodeDelete(this.graph, processed, "deleted")).compose(nil -> Future.succeededFuture((Object)node));
    }

    @Override
    public Future<JsonArray> delete(JsonArray nodes) {
        return this.doAsync(N4J.nodeUnique(nodes), "deleted", (JsonArray processed) -> N4J.nodeDelete(this.graph, processed, "deleted")).compose(nil -> Future.succeededFuture((Object)nodes));
    }

    private JsonObject unique(JsonObject data) {
        JsonObject condition = N4J.nodeUnique(data);
        N4J.infoNode(this.getClass(), "Cond: {0}", condition.encode());
        return condition;
    }

    private JsonArray unique(JsonArray data) {
        JsonArray condition = N4J.nodeUnique(data);
        N4J.infoNode(this.getClass(), "Cond: {0}", condition.encode());
        return condition;
    }

    @Override
    protected Session session() {
        return this.driver.session();
    }
}

