/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.neo4j.sync;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.neo4j.refine.N4J;
import io.vertx.tp.plugin.neo4j.sync.AbstractN4JExecutor;
import java.util.HashSet;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;

public class GraphicAnalyzer
extends AbstractN4JExecutor {
    private final transient String graph;
    private final transient Driver driver;

    private GraphicAnalyzer(String graph, Driver driver) {
        this.graph = graph;
        this.driver = driver;
    }

    public static GraphicAnalyzer create(String graph, Driver driver) {
        return new GraphicAnalyzer(graph, driver);
    }

    public Future<JsonObject> searchAsync(JsonObject node, Integer integer) {
        String command = N4J.graphicByKey(this.graph, integer);
        N4J.infoEdge(this.getClass(), "Command: {0}", command);
        Session session = this.session();
        Transaction transaction = session.beginTransaction();
        Result result = transaction.run(command, N4J.parameters(node));
        JsonObject response = new JsonObject();
        JsonArray nodes = new JsonArray();
        JsonArray edges = new JsonArray();
        HashSet duplicated = new HashSet();
        result.stream().forEach(record -> {
            JsonObject to;
            JsonObject from = N4J.toJson(record.get("from"));
            if (!duplicated.contains(from.getString("key"))) {
                nodes.add(from);
                duplicated.add(from.getString("key"));
            }
            if (!duplicated.contains((to = N4J.toJson(record.get("to"))).getString("key"))) {
                nodes.add(to);
                duplicated.add(to.getString("key"));
            }
            edges.add(N4J.toJson(record.get("edge")));
        });
        response.put("nodes", nodes);
        response.put("edges", edges);
        transaction.commit();
        transaction.close();
        session.close();
        return Future.succeededFuture((Object)response);
    }

    @Override
    protected Session session() {
        return this.driver.session();
    }
}

