/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.neo4j.sync;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.neo4j.refine.N4J;
import io.vertx.tp.plugin.neo4j.sync.N4JExecutor;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.driver.Session;

public abstract class AbstractN4JExecutor {
    protected JsonObject doSync(JsonObject processed, String alias, Function<JsonObject, String> consumer) {
        String command = consumer.apply(processed);
        N4J.infoNode(this.getClass(), "Alias: {1}, Command: {0}", command, alias);
        N4JExecutor executor = N4JExecutor.create().bind(this.session());
        return executor.execute(command, processed, alias);
    }

    protected JsonArray doSync(JsonArray processed, Function<JsonArray, List<String>> consumer) {
        List<String> command = consumer.apply(processed);
        N4J.debugEdge(this.getClass(), "Command: {0}", command);
        N4JExecutor executor = N4JExecutor.create().bind(this.session());
        return executor.execute(command, processed);
    }

    private JsonObject doSync(JsonObject processed, Function<JsonObject, String> consumer) {
        String command = consumer.apply(processed);
        N4J.debugEdge(this.getClass(), "Command: {0}", command);
        N4JExecutor executor = N4JExecutor.create().bind(this.session());
        return executor.execute(command, processed);
    }

    private JsonArray doSync(JsonArray processed, String alias, Function<JsonArray, List<String>> consumer) {
        List<String> commands = consumer.apply(processed);
        N4J.infoNode(this.getClass(), "Alias: {1}, Size: {0}", commands.size(), alias);
        N4JExecutor executor = N4JExecutor.create().bind(this.session());
        return executor.execute(commands, processed, alias);
    }

    protected Future<JsonArray> doAsync(JsonArray processed, Function<JsonArray, List<String>> consumer) {
        return Future.succeededFuture((Object)this.doSync(processed, consumer));
    }

    protected Future<JsonObject> doAsync(JsonObject processed, Function<JsonObject, String> consumer) {
        return Future.succeededFuture((Object)this.doSync(processed, consumer));
    }

    protected Future<JsonObject> doAsync(JsonObject processed, String alias, Function<JsonObject, String> consumer) {
        return Future.succeededFuture((Object)this.doSync(processed, alias, consumer));
    }

    protected Future<JsonArray> doAsync(JsonArray processed, String alias, Function<JsonArray, List<String>> consumer) {
        return Future.succeededFuture((Object)this.doSync(processed, alias, consumer));
    }

    protected void execute(Supplier<List<String>> supplier) {
        List<String> commands = supplier.get();
        N4JExecutor executor = N4JExecutor.create().bind(this.session());
        executor.execute(commands);
    }

    protected abstract Session session();
}

