/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.neo4j;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.neo4j.Neo4JSession;
import io.vertx.tp.plugin.neo4j.Neo4jClient;
import io.vertx.tp.plugin.neo4j.Neo4jConfig;
import io.vertx.tp.plugin.neo4j.refine.N4J;
import io.vertx.tp.plugin.neo4j.sync.GraphicAnalyzer;
import io.vertx.tp.plugin.neo4j.sync.N4JSession;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;

public class Neo4jClientImpl
implements Neo4jClient {
    private static final Annal LOGGER = Annal.get(Neo4jClientImpl.class);
    private final transient Vertx vertx;
    private transient Neo4jConfig config;
    private transient Driver driver;
    private transient String graph = "default";
    private transient Neo4JSession session;
    private transient GraphicAnalyzer analyzer;

    Neo4jClientImpl(Vertx vertx, Neo4jConfig config) {
        this.vertx = vertx;
        this.config = config;
        this.initDatabase();
    }

    private void initDatabase() {
        String uri = this.config.uri();
        LOGGER.info("[ ZERO ] Graphic database initialized: {0}", new Object[]{uri});
        this.driver = GraphDatabase.driver((String)uri, (AuthToken)this.config.token(), (Config)this.config.config());
    }

    @Override
    public Neo4jClient init(JsonObject params) {
        this.config = Neo4jConfig.create(params);
        this.initDatabase();
        return this;
    }

    @Override
    public Neo4jClient connect(String graph) {
        if (Ut.notNil((String)graph)) {
            this.graph = graph;
        }
        if (!this.config.isAsync()) {
            this.session = new N4JSession(this.graph);
            this.session.bind(this.driver).constraints();
            this.analyzer = GraphicAnalyzer.create(this.graph, this.driver);
        }
        return this;
    }

    @Override
    public boolean connected() {
        try {
            this.driver.verifyConnectivity();
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public Future<JsonObject> nodeCreate(JsonObject node) {
        return this.session.create(node);
    }

    @Override
    public Future<JsonArray> nodeCreate(JsonArray nodes) {
        return this.session.create(nodes);
    }

    @Override
    public Future<JsonObject> nodeUpdate(JsonObject node) {
        return this.session.update(node);
    }

    @Override
    public Future<JsonArray> nodeUpdate(JsonArray nodes) {
        return this.session.update(nodes);
    }

    @Override
    public Future<JsonObject> nodeRemove(JsonObject node) {
        return this.session.delete(node);
    }

    @Override
    public Future<JsonArray> nodeRemove(JsonArray nodes) {
        return this.session.delete(nodes);
    }

    @Override
    public Future<JsonObject> nodeFind(String key) {
        return this.session.find(new JsonObject().put("key", key));
    }

    @Override
    public boolean nodeExisting(String key) {
        return Ut.notNil((JsonObject)this.session.findSync(new JsonObject().put("key", key)));
    }

    @Override
    public Future<JsonObject> edgeCreate(JsonObject edge) {
        return this.session.link(edge);
    }

    @Override
    public Future<JsonArray> edgeCreate(JsonArray edge) {
        return this.session.link(edge);
    }

    @Override
    public Future<JsonObject> edgeUpdate(JsonObject edge) {
        return this.session.relink(edge);
    }

    @Override
    public Future<JsonArray> edgeUpdate(JsonArray edge) {
        return this.session.relink(edge);
    }

    @Override
    public Future<JsonObject> edgeRemove(JsonObject edge) {
        return this.session.unlink(edge);
    }

    @Override
    public Future<JsonArray> edgeRemove(JsonArray edge) {
        return this.session.unlink(edge);
    }

    @Override
    public Future<JsonObject> graphic(JsonObject node) {
        return this.graphic(node, -1);
    }

    @Override
    public Future<JsonObject> graphic(JsonObject node, Integer level) {
        if (Objects.isNull(node)) {
            return Ux.future((Object)N4J.graphicDefault());
        }
        N4J.infoNode(this.getClass(), "Node found: {0}", node.encode());
        return this.analyzer.searchAsync(node, level);
    }

    @Override
    public Future<JsonObject> graphicByKey(String key) {
        return this.nodeFind(key).compose(this::graphic);
    }

    @Override
    public Future<JsonObject> graphicByKey(String key, Integer level) {
        return this.nodeFind(key).compose(node -> this.graphic((JsonObject)node, level));
    }

    @Override
    public Future<Boolean> graphicReset() {
        return this.session.reset();
    }
}

