/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.mongo;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.fn.Fn;
import io.vertx.up.plugin.Infix;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Plugin
public class MongoInfix
implements Infix {
    private static final String NAME = "ZERO_MONGO_POOL";
    private static final ConcurrentMap<String, MongoClient> CLIENTS = new ConcurrentHashMap<String, MongoClient>();

    private static void initInternal(Vertx vertx, String name) {
        Fn.pool(CLIENTS, (Object)name, () -> (MongoClient)Infix.init((String)"mongo", config -> MongoClient.createShared((Vertx)vertx, (JsonObject)config, (String)name), MongoInfix.class));
    }

    public static void init(Vertx vertx) {
        MongoInfix.initInternal(vertx, NAME);
    }

    public static MongoClient getClient() {
        return (MongoClient)CLIENTS.get(NAME);
    }

    public MongoClient get() {
        return MongoInfix.getClient();
    }
}

