/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.qiy;

import io.horizon.specification.uca.HLogger;
import io.horizon.uca.log.Annal;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._401QiyTokenException;
import io.vertx.tp.plugin.qiy.QiyClient;
import io.vertx.tp.plugin.qiy.QiyConfig;
import io.vertx.tp.plugin.qiy.QiyRepdor;
import io.vertx.tp.plugin.qiy.api.QiyAuthorize;
import io.vertx.tp.plugin.qiy.api.QiyUpload;
import io.vertx.up.fn.Fn;

public class QiyClientImpl
implements QiyClient {
    private static final Annal LOGGER = Annal.get(QiyClientImpl.class);
    private final transient Vertx vertx;
    private final transient QiyAuthorize authorizeApi;
    private transient QiyConfig config;

    QiyClientImpl(Vertx vertx, QiyConfig config) {
        this.vertx = vertx;
        this.config = config;
        this.authorizeApi = config.getInitApi(QiyAuthorize.class);
    }

    @Override
    public QiyClient init(JsonObject config) {
        LOGGER.info("Qiy token record has been refreshed: {0}", new Object[]{config});
        this.config = QiyConfig.create(config);
        return this;
    }

    @Override
    public QiyClient authorize(Handler<AsyncResult<JsonObject>> handler) {
        QiyRepdor.handle(this.authorizeApi.authorize(this.config.getClientId(), this.config.getClientSecret())).onComplete(res -> {
            this.config.setToken((JsonObject)res.result());
            handler.handle((Object)Future.succeededFuture((Object)((JsonObject)res.result())));
        });
        return this;
    }

    @Override
    public QiyClient refreshToken(String refreshToken, Handler<AsyncResult<JsonObject>> handler) {
        QiyRepdor.handle(this.authorizeApi.refreshToken(this.config.getClientId(), refreshToken)).onComplete(res -> {
            this.config.setToken((JsonObject)res.result());
            handler.handle((Object)Future.succeededFuture((Object)((JsonObject)res.result())));
        });
        return this;
    }

    @Override
    public QiyClient requestFile(String fileType, String fileSize, Handler<AsyncResult<JsonObject>> handler) {
        Fn.outWeb((null == this.config || !this.config.isValid() ? 1 : 0) != 0, (HLogger)LOGGER, _401QiyTokenException.class, (Object[])new Object[]{this.getClass(), this.config.getClientId()});
        QiyUpload uploadApi = this.config.getUpApi(QiyUpload.class);
        QiyRepdor.complete(uploadApi.requestUpload(fileType, fileSize, this.config.getAccessToken())).onComplete(res -> handler.handle((Object)Future.succeededFuture((Object)((JsonObject)res.result()))));
        return this;
    }

    @Override
    public QiyClient upload(String address, String size, String range, String fileId, char[] content) {
        return this;
    }
}

