/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.elasticsearch;

import io.vertx.core.Vertx;
import io.vertx.tp.plugin.elasticsearch.ElasticSearchClient;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.fn.Fn;
import io.vertx.up.plugin.Infix;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Plugin
public class ElasticSearchInfix
implements Infix {
    private static final String NAME = "ZERO_ELASTIC_SEARCH_POOL";
    private static final ConcurrentMap<String, ElasticSearchClient> CLIENTS = new ConcurrentHashMap<String, ElasticSearchClient>();

    private static void initInternal(Vertx vertx) {
        Fn.pool(CLIENTS, (Object)NAME, () -> (ElasticSearchClient)Infix.initTp((String)"elasticsearch", config -> ElasticSearchClient.createShared(vertx, config), ElasticSearchInfix.class));
    }

    public static void init(Vertx vertx) {
        ElasticSearchInfix.initInternal(vertx);
    }

    public static ElasticSearchClient getClient() {
        return (ElasticSearchClient)CLIENTS.get(NAME);
    }

    public ElasticSearchClient get() {
        return ElasticSearchInfix.getClient();
    }
}

