/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.connect;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.ke.atom.metadata.KJoin;
import io.vertx.tp.ke.atom.metadata.KPoint;
import io.vertx.tp.ke.cv.em.JoinMode;
import io.vertx.up.commune.Envelop;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import java.util.function.BiFunction;

interface OxSwitcher {
    public static JsonObject getData(JsonObject original, IxModule module) {
        KJoin connect = module.getConnect();
        JsonObject inputData = original.copy();
        KPoint target = connect.procTarget(original);
        connect.procFilters(original, target, inputData);
        return inputData;
    }

    public static JsonObject getCondition(JsonObject original, IxModule module) {
        JsonObject filters = new JsonObject();
        KJoin connect = module.getConnect();
        KPoint target = connect.procTarget(original);
        connect.procFilters(original, target, filters);
        if (original.containsKey("sigma")) {
            filters.put("", Boolean.TRUE);
            filters.put("sigma", original.getString("sigma"));
        }
        return filters;
    }

    public static Future<Envelop> moveOn(JsonObject data, MultiMap headers, IxModule module, BiFunction<UxJooq, IxModule, Future<Envelop>> function) {
        KJoin connect = module.getConnect();
        Annal LOGGER = Annal.get(OxSwitcher.class);
        if (Objects.isNull(connect)) {
            Ix.infoDao(LOGGER, "KJoin is null", new Object[0]);
            return Ux.future((Object)Envelop.success((Object)data));
        }
        KPoint target = connect.procTarget(data);
        if (Objects.isNull(target) || JoinMode.CRUD != target.modeTarget()) {
            return Ux.future((Object)Envelop.success((Object)data));
        }
        if (!1.$assertionsDisabled && !Objects.nonNull(target.getCrud())) {
            throw new AssertionError((Object)"Here the 'crud' field could not be null, because of passed 'modeTarget' checking.");
        }
        IxModule joinedModule = IxPin.getActor(target.getCrud());
        UxJooq dao = IxPin.getDao(joinedModule, headers);
        return function.apply(dao, joinedModule);
    }

    public static Future<Envelop> moveEnd(JsonObject original, Envelop response, IxModule config) {
        JsonObject createdJoined = (JsonObject)response.data();
        if (Objects.isNull(createdJoined)) {
            createdJoined = new JsonObject();
        } else {
            String joinedField = config.getField().getKey();
            createdJoined.put("joinedKey", createdJoined.getString(joinedField));
        }
        createdJoined.mergeIn(original, true);
        return Ux.future((Object)Envelop.success((Object)createdJoined));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

