/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.atom;

import com.fasterxml.jackson.databind.ClassDeserializer;
import com.fasterxml.jackson.databind.ClassSerializer;
import com.fasterxml.jackson.databind.JsonArrayDeserializer;
import com.fasterxml.jackson.databind.JsonArraySerializer;
import com.fasterxml.jackson.databind.JsonObjectDeserializer;
import com.fasterxml.jackson.databind.JsonObjectSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxColumn;
import io.vertx.tp.crud.atom.IxField;
import io.vertx.tp.crud.atom.IxJoin;
import io.vertx.tp.crud.cv.em.DsMode;
import io.vertx.up.commune.config.Dict;
import io.vertx.up.commune.config.DictEpsilon;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

public class IxModule
implements Serializable {
    private String name;
    private String table;
    private String pojo;
    private String mode;
    private String modeKey;
    private IxField field;
    private IxColumn column;
    private IxJoin connect;
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private JsonObject epsilon;
    @JsonSerialize(using=JsonArraySerializer.class)
    @JsonDeserialize(using=JsonArrayDeserializer.class)
    private JsonArray source;
    @JsonSerialize(using=ClassSerializer.class)
    @JsonDeserialize(using=ClassDeserializer.class)
    private Class<?> pojoCls;
    @JsonSerialize(using=ClassSerializer.class)
    @JsonDeserialize(using=ClassDeserializer.class)
    private Class<?> daoCls;
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private JsonObject header;

    public IxField getField() {
        return this.field;
    }

    public void setField(IxField field) {
        this.field = field;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentifier() {
        if (Objects.nonNull(this.column)) {
            return this.column.getIdentifier();
        }
        return null;
    }

    public String getPojo() {
        return this.pojo;
    }

    public void setPojo(String pojo) {
        this.pojo = pojo;
    }

    public Class<?> getPojoCls() {
        return this.pojoCls;
    }

    public void setPojoCls(Class<?> pojoCls) {
        this.pojoCls = pojoCls;
    }

    public Class<?> getDaoCls() {
        return this.daoCls;
    }

    public void setDaoCls(Class<?> daoCls) {
        this.daoCls = daoCls;
    }

    public JsonObject getHeader() {
        return this.header;
    }

    public void setHeader(JsonObject header) {
        this.header = header;
    }

    public IxColumn getColumn() {
        return this.column;
    }

    public void setColumn(IxColumn column) {
        this.column = column;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public IxJoin getConnect() {
        return this.connect;
    }

    public void setConnect(IxJoin connect) {
        this.connect = connect;
    }

    public ConcurrentMap<String, DictEpsilon> getEpsilon() {
        return Ux.dictEpsilon((JsonObject)(Objects.isNull(this.epsilon) ? new JsonObject() : this.epsilon));
    }

    public void setEpsilon(JsonObject epsilon) {
        this.epsilon = epsilon;
    }

    public Dict getSource() {
        JsonArray source = Objects.isNull(this.source) ? new JsonArray() : this.source;
        return new Dict(source);
    }

    public void setSource(JsonArray source) {
        this.source = source;
    }

    public DsMode getMode() {
        if (Objects.isNull(this.mode)) {
            return DsMode.PRIMARY;
        }
        return (DsMode)Ut.toEnum(() -> this.mode, DsMode.class, (Enum)DsMode.PRIMARY);
    }

    public void setMode(DsMode mode) {
        this.mode = Objects.isNull((Object)mode) ? DsMode.PRIMARY.name() : mode.name();
    }

    public String getModeKey() {
        return this.modeKey;
    }

    public void setModeKey(String modeKey) {
        this.modeKey = modeKey;
    }

    public String toString() {
        return "IxModule{name='" + this.name + '\'' + ", table='" + this.table + '\'' + ", pojo='" + this.pojo + '\'' + ", mode='" + this.mode + '\'' + ", modeKey='" + this.modeKey + '\'' + ", field=" + this.field + ", column=" + this.column + ", connect=" + this.connect + ", epsilon=" + this.epsilon + ", source=" + this.source + ", pojoCls=" + this.pojoCls + ", daoCls=" + this.daoCls + ", header=" + this.header + '}';
    }
}

