/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.sql;

import io.horizon.uca.cache.Cc;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.config.Database;
import io.vertx.up.util.Ut;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SqlTypeProvider {
    private static final ConcurrentMap<String, String> DB_MAPPING = new ConcurrentHashMap<String, String>();
    private static final ConcurrentMap<String, JsonArray> DB_TYPE_MAPPING = new ConcurrentHashMap<String, JsonArray>();
    private static final Cc<String, SqlTypeProvider> CC_PROVIDER = Cc.open();

    private SqlTypeProvider(Database database) {
        JsonObject schemaData = Ut.ioJObject((String)("engine/database/sql/" + database.getCategory().name() + "/schema.json"));
        JsonObject definitions = schemaData.getJsonObject("definitions");
        for (String field : definitions.fieldNames()) {
            if (!Ut.isNotNil((String)field) || null == definitions.getValue(field)) continue;
            DB_MAPPING.put(field, definitions.getString(field));
        }
        JsonObject typeMappings = schemaData.getJsonObject("mappings");
        for (String field : typeMappings.fieldNames()) {
            if (!Ut.isNotNil((String)field) || null == typeMappings.getValue(field)) continue;
            DB_TYPE_MAPPING.put(field, typeMappings.getJsonArray(field));
        }
    }

    public static SqlTypeProvider create(Database database) {
        return (SqlTypeProvider)CC_PROVIDER.pick(() -> new SqlTypeProvider(database), (Object)database.getCategory().name());
    }

    public String getColumnType(String key) {
        return (String)DB_MAPPING.get(key);
    }

    public JsonArray getMappingList(String key) {
        return (JsonArray)DB_TYPE_MAPPING.get(key);
    }
}

