/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.reference;

import io.aeon.experiment.reference.RDao;
import io.aeon.experiment.reference.RQuote;
import io.horizon.atom.common.Kv;
import io.horizon.specification.modeler.HRule;
import io.modello.specification.HRecord;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;

class RaySource {
    private final transient RQuote quote;

    private RaySource(RQuote quote) {
        this.quote = quote;
    }

    static RaySource create(RQuote quote) {
        return new RaySource(quote);
    }

    public ConcurrentMap<String, JsonArray> single(HRecord record) {
        return this.data(rule -> rule.condition(record));
    }

    public Future<ConcurrentMap<String, JsonArray>> singleAsync(HRecord record) {
        return this.dataAsync(rule -> rule.condition(record));
    }

    public ConcurrentMap<String, JsonArray> batch(HRecord[] records) {
        return this.data(rule -> rule.condition(records));
    }

    public Future<ConcurrentMap<String, JsonArray>> batchAsync(HRecord[] records) {
        return this.dataAsync(rule -> rule.condition(records));
    }

    private Future<ConcurrentMap<String, JsonArray>> dataAsync(Function<HRule, JsonObject> supplier) {
        return this.ready(supplier, (fieldCodes, execMap) -> {
            ConcurrentHashMap futureMap = new ConcurrentHashMap();
            execMap.forEach((hashCode, kv) -> {
                JsonObject condition = (JsonObject)kv.key();
                RDao dao = (RDao)kv.value();
                futureMap.put(hashCode, Rapid.t((String)"ZERO-CACHE-REFERENCE", (int)300).cached((Object)String.valueOf(hashCode), () -> {
                    Ao.LOG.Uca.info(this.getClass(), "Async Batch condition building: {0}", new Object[]{condition.encode()});
                    return dao.fetchByAsync(condition);
                }));
            });
            return Fn.combineM(futureMap).compose(queriedMap -> {
                ConcurrentHashMap data = new ConcurrentHashMap();
                queriedMap.forEach((hashCode, dataArray) -> fieldCodes.forEach((field, codeKey) -> {
                    if (Objects.equals(hashCode, codeKey)) {
                        data.put(field, dataArray);
                    }
                }));
                return Ux.future(data);
            });
        });
    }

    private ConcurrentMap<String, JsonArray> data(Function<HRule, JsonObject> supplier) {
        return this.ready(supplier, (fieldCodes, execMap) -> {
            ConcurrentHashMap data = new ConcurrentHashMap();
            execMap.forEach((hashCode, kv) -> {
                JsonObject condition = (JsonObject)kv.key();
                RDao dao = (RDao)kv.value();
                JsonArray queried = dao.fetchBy(condition);
                Ao.LOG.Uca.info(this.getClass(), "Batch condition building: {0}, size = {1}", new Object[]{condition.encode(), String.valueOf(queried.size())});
                fieldCodes.forEach((field, codeKey) -> {
                    if (Objects.equals(hashCode, codeKey)) {
                        data.put(field, queried);
                    }
                });
            });
            return data;
        });
    }

    private <T> T ready(Function<HRule, JsonObject> supplier, BiFunction<ConcurrentMap<String, Integer>, ConcurrentMap<Integer, Kv<JsonObject, RDao>>, T> executor) {
        ConcurrentHashMap fieldCodes = new ConcurrentHashMap();
        ConcurrentHashMap execMap = new ConcurrentHashMap();
        this.quote.rules().forEach((field, rule) -> {
            JsonObject condition = (JsonObject)supplier.apply((HRule)rule);
            if (Objects.nonNull(condition)) {
                int hashCode = condition.hashCode();
                fieldCodes.put(field, hashCode);
                RDao dao = this.quote.dao(field);
                execMap.put(hashCode, Kv.create((Object)condition, (Object)dao));
            }
        });
        return executor.apply(fieldCodes, execMap);
    }
}

