/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.reference;

import io.aeon.experiment.reference.RResult;
import io.horizon.specification.modeler.HReference;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.atom.modeling.builtin.DataAtom;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.error._501AnonymousAtomException;
import io.vertx.tp.modular.reference.AoRay;
import io.vertx.tp.modular.reference.RaySource;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractRay<T>
implements AoRay<T> {
    protected transient DataTpl tpl;
    protected transient ConcurrentMap<String, RaySource> input = new ConcurrentHashMap<String, RaySource>();
    protected transient ConcurrentMap<String, RResult> output = new ConcurrentHashMap<String, RResult>();

    @Override
    public AoRay<T> on(DataTpl tpl) {
        this.tpl = tpl;
        DataAtom atom = tpl.atom();
        if (Objects.isNull((Object)atom)) {
            throw new _501AnonymousAtomException(tpl.getClass());
        }
        HReference reference = atom.reference();
        reference.refInput().forEach((identifier, quote) -> {
            RaySource source = RaySource.create(quote);
            this.input.put((String)identifier, source);
        });
        this.output.putAll(reference.refOutput());
        return this;
    }

    @Override
    public T doRay(T input) {
        if (this.input.isEmpty()) {
            return input;
        }
        return this.exec(input);
    }

    @Override
    public Future<T> doRayAsync(T input) {
        if (this.input.isEmpty()) {
            return Ux.future(input);
        }
        return this.execAsync(input);
    }

    public abstract T exec(T var1);

    public abstract Future<T> execAsync(T var1);

    protected Future<ConcurrentMap<String, JsonArray>> thenCombine(List<Future<ConcurrentMap<String, JsonArray>>> futures) {
        return Fn.combineT(futures).compose(listMap -> {
            ConcurrentHashMap response = new ConcurrentHashMap();
            listMap.forEach(response::putAll);
            return Ux.future(response);
        });
    }
}

