/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq.internal;

import io.horizon.uca.log.Annal;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.modeling.element.DataRow;
import io.vertx.tp.modular.jooq.internal.IArgument;
import io.vertx.tp.modular.jooq.internal.IWhere;
import io.vertx.tp.modular.jooq.internal.Meta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Table;

public class Jq {
    private static final Annal LOGGER = Annal.get(Jq.class);

    public static Field toField(String field, Set<DataMatrix> matrix, ConcurrentMap<String, String> fieldMap) {
        return Meta.field(field, matrix, fieldMap);
    }

    public static Table<Record> toTable(String name) {
        return Meta.table(name);
    }

    public static Record toRecord(Result<Record> result) {
        if (Objects.isNull(result) || result.isEmpty()) {
            return null;
        }
        return (Record)result.get(0);
    }

    public static Record[] toRecords(Result<Record> result) {
        ArrayList records = new ArrayList();
        result.forEach(records::add);
        return records.toArray(new Record[0]);
    }

    public static Long toCount(Result<Record> result) {
        if (Objects.isNull(result) || result.isEmpty()) {
            return 0L;
        }
        Record record = (Record)result.get(0);
        if (Objects.isNull(record)) {
            return 0L;
        }
        return (Long)record.get(0, Long.class);
    }

    public static Table<Record> joinNature(ConcurrentMap<String, String> aliasMap) {
        return Meta.natureJoin(aliasMap);
    }

    public static Table<Record> joinLeft(String leader, ConcurrentMap<String, String> vectors, ConcurrentMap<String, String> aliasMap) {
        return Meta.leftJoin(leader, vectors, aliasMap);
    }

    public static <T> void argSet(DataMatrix matrix, BiFunction<Field, Object, T> function) {
        IArgument.inSet(matrix, function);
    }

    public static ConcurrentMap<String, List<DataMatrix>> argBatch(List<DataRow> rows) {
        return IArgument.inBatch(rows);
    }

    public static Condition inWhere(DataMatrix matrix) {
        return Jq.inMonitor(() -> IWhere.key(matrix), "onKey");
    }

    public static Condition inWhere(List<DataMatrix> matrixList) {
        return Jq.inMonitor(() -> IWhere.keys(matrixList), "onKeys");
    }

    private static Condition inMonitor(Supplier<Condition> supplier, String method) {
        Condition condition = supplier.get();
        LOGGER.debug("[ Ox ] \u65b9\u6cd5\uff1a{0}\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a{1}", new Object[]{method, condition});
        return condition;
    }
}

