/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq.internal;

import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.modeling.element.DataRow;
import io.vertx.tp.modular.jooq.internal.Meta;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.jooq.Field;

class IArgument {
    IArgument() {
    }

    static <T> void inSet(DataMatrix matrix, BiFunction<Field, Object, T> function) {
        matrix.getAttributes().forEach(field -> {
            Field column = Meta.field(field, matrix);
            Object value = matrix.getValue((String)field);
            if (Objects.nonNull(value)) {
                Class<?> typeIn;
                Class typeDef = column.getType();
                if (typeDef == (typeIn = value.getClass())) {
                    function.apply(column, value);
                } else {
                    Object normalized = Ut.aiValue((Object)value, (Class)typeDef);
                    if (Objects.nonNull(normalized)) {
                        function.apply(column, normalized);
                    }
                }
            } else {
                function.apply(column, null);
            }
        });
    }

    static ConcurrentMap<String, List<DataMatrix>> inBatch(List<DataRow> rows) {
        ConcurrentHashMap<String, List<DataMatrix>> resultMap = new ConcurrentHashMap<String, List<DataMatrix>>();
        rows.forEach(row -> {
            ConcurrentMap<String, DataMatrix> rowData = row.matrixData();
            rowData.forEach((table, matrix) -> {
                if (!resultMap.containsKey(table)) {
                    resultMap.put((String)table, new ArrayList());
                }
                ((List)resultMap.get(table)).add(matrix);
            });
        });
        return resultMap;
    }
}

