/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.file;

import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.file.AoFile;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FileReader
implements AoFile {
    @Override
    public Set<Model> readModels(String appName) {
        return this.readModels(appName, null);
    }

    @Override
    public Set<Model> readModels(String appName, String outPath) {
        Set<String> schemaFiles = this.readFiles("schema", outPath);
        Set schemata = schemaFiles.stream().map(file -> Ao.toSchema(appName, file)).collect(Collectors.toSet());
        Set<String> files = this.readFiles("model", outPath);
        return files.stream().map(file -> Ao.toModel(appName, file)).map(model -> model.bind(schemata)).collect(Collectors.toSet());
    }

    @Override
    public Set<String> readServices() {
        return this.readFiles("service", null);
    }

    @Override
    public Set<String> readDataFiles() {
        return null;
    }

    private Set<String> readFiles(String folder, String outPath) {
        String filePath = Ut.isNil((String)outPath) ? Ao.PATH.PATH_JSON + folder : outPath + folder;
        List files = Ut.ioFiles((String)filePath);
        HashSet<String> results = new HashSet<String>();
        files.forEach(file -> results.add(filePath + "/" + file));
        return results;
    }
}

