/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.file;

import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.file.AoFile;
import io.vertx.tp.modular.file.excel.ExAnalyzer;
import io.vertx.tp.modular.file.excel.ExModello;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ExcelReader
implements AoFile {
    private final transient String rootPath;

    public ExcelReader() {
        this(Ao.PATH.PATH_EXCEL);
    }

    public ExcelReader(String rootPath) {
        Object normalized = Objects.isNull(rootPath) ? Ao.PATH.PATH_EXCEL : (!rootPath.endsWith("/") ? rootPath + "/" : rootPath);
        this.rootPath = normalized;
    }

    @Override
    public Set<Model> readModels(String appName) {
        return this.readModels(appName, null);
    }

    @Override
    public Set<Model> readModels(String appName, String outPath) {
        Object folder = Ut.isNil((String)outPath) ? this.rootPath + "meta" : outPath;
        Set<String> files = this.readFiles((String)folder);
        Ao.LOG.Uca.info(this.getClass(), "\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6587\u4ef6\uff1a{0}", new Object[]{String.valueOf(files.size())});
        Set<Schema> schemas = ExModello.create(files).on(appName).build();
        Ao.LOG.Uca.info(this.getClass(), "\u5408\u8ba1\u6784\u9020\u4e86\u6a21\u578b\uff1a{0}", new Object[]{schemas.size()});
        HashSet<Model> models = new HashSet<Model>();
        files.stream().map(ExAnalyzer::create).map(analyzer -> analyzer.on(appName)).map(analyzer -> analyzer.build(schemas)).forEach(models::addAll);
        return models;
    }

    @Override
    public Set<String> readServices() {
        return null;
    }

    @Override
    public Set<String> readDataFiles() {
        String root = this.rootPath + "data";
        return this.readFiles(root);
    }

    private Set<String> readFiles(String folder) {
        List files = Ut.ioFiles((String)folder);
        return files.stream().filter(file -> file.endsWith(".xlsx") || file.equals("xls")).filter(file -> !file.startsWith("~")).map(item -> folder + "/" + item).collect(Collectors.toSet());
    }
}

