/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.refine;

import io.aeon.experiment.mixture.HLoad;
import io.aeon.experiment.specification.app.HES;
import io.horizon.atom.app.KApp;
import io.horizon.specification.modeler.HAtom;
import io.horizon.specification.modeler.HDao;
import io.horizon.spi.mixture.HLoadAtom;
import io.horizon.spi.robin.Switcher;
import io.horizon.uca.cache.Cc;
import io.modello.specification.HRecord;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.modeling.builtin.DataAtom;
import io.vertx.tp.atom.modeling.data.DataRecord;
import io.vertx.tp.atom.refine.AoStore;
import io.vertx.tp.modular.jdbc.Pin;
import io.vertx.tp.plugin.database.DS;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.up.commune.config.Database;
import io.vertx.up.commune.config.Identity;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Supplier;

class AoImpl {
    public static final Cc<String, HLoad> CC_LOAD = Cc.openThread();
    private static final Cc<Integer, Switcher> CC_SWITCHER = Cc.open();
    private static final Cc<String, HDao> CC_T_DAO = Cc.openThread();

    AoImpl() {
    }

    private static Schema toSchema(String appName) {
        Class<?> implSchema = AoStore.clazzSchema();
        return (Schema)Ut.instance(implSchema, (Object[])new Object[]{AoStore.namespace(appName)});
    }

    static Schema toSchema(String appName, JsonObject schemaJson) {
        Schema schemaObj = AoImpl.toSchema(appName);
        schemaObj.fromJson(schemaJson);
        return schemaObj;
    }

    static Schema toSchema(String appName, String file) {
        Schema schemaObj = AoImpl.toSchema(appName);
        schemaObj.fromFile(file);
        return schemaObj;
    }

    static Model toModel(String appName) {
        KApp app = HES.connect((String)appName).bind(AoStore.namespace(appName));
        Class<?> implModel = AoStore.clazzModel();
        return (Model)Ut.instance(implModel, (Object[])new Object[]{app});
    }

    static Switcher toSwitcher(Identity identity, JsonObject options) {
        return (Switcher)CC_SWITCHER.pick(() -> {
            Class<?> implSwitcher = AoStore.clazzSwitcher();
            return (Switcher)Ut.instance(implSwitcher, (Object[])new Object[]{identity, options});
        }, (Object)identity.hashCode());
    }

    static DataAtom toAtom(JsonObject options) {
        String identifier = options.getString("identifier");
        String name = options.getString("name");
        return AoImpl.toAtom(name, identifier);
    }

    static DataAtom toAtom(String appName, String identifier) {
        HLoad loader = (HLoad)CC_LOAD.pick(HLoadAtom::new);
        HAtom atom = loader.atom(appName, identifier);
        if (atom instanceof DataAtom) {
            return (DataAtom)atom;
        }
        return null;
    }

    static HDao toDao(HAtom atom) {
        return (HDao)Ux.channelS(DS.class, ds -> {
            DataPool pool = ds.switchDs(atom.sigma());
            if (Objects.nonNull(pool)) {
                Database database = pool.getDatabase();
                return AoImpl.toDao(() -> atom, database);
            }
            return null;
        });
    }

    static HDao toDao(Supplier<HAtom> supplier, Database database) {
        if (Objects.isNull(database)) {
            return null;
        }
        HAtom atom = supplier.get();
        if (Objects.isNull(atom)) {
            return null;
        }
        Pin pin = Pin.getInstance();
        return (HDao)CC_T_DAO.pick(() -> pin.getDao(database).mount(atom), (Object)atom.identifier());
    }

    static DataAtom toAtom(String identifier) {
        KApp env = HES.connect();
        if (Objects.nonNull(env)) {
            return AoImpl.toAtom(env.name(), identifier);
        }
        return null;
    }

    static HRecord toRecord(String identifier, JsonObject data) {
        DataAtom atom = AoImpl.toAtom(identifier);
        if (Objects.isNull((Object)atom)) {
            return null;
        }
        DataRecord record = new DataRecord();
        Ut.contract((Object)((Object)record), DataAtom.class, (Object)((Object)atom));
        return Ux.updateR((HRecord)record, (JsonObject)data);
    }

    static HDao toDao(String identifier) {
        KApp env = HES.connect();
        DataAtom atom = Objects.nonNull(env) ? AoImpl.toAtom(env.name(), identifier) : null;
        if (Objects.nonNull(atom)) {
            return AoImpl.toDao(() -> atom, (Database)env.database());
        }
        return null;
    }
}

