/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.element;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MField;
import cn.vertxup.atom.domain.tables.pojos.MJoin;
import io.horizon.eon.em.modeler.ModelType;
import io.horizon.uca.cache.Cc;
import io.modello.specification.HRecord;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.modeling.builtin.DataAtom;
import io.vertx.tp.atom.modeling.element.DataKey;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.metadata.AoSentence;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class DataTpl
implements Serializable {
    private final transient ConcurrentMap<String, DataMatrix> tpl = new ConcurrentHashMap<String, DataMatrix>();
    private final transient ConcurrentMap<String, String> sources = new ConcurrentHashMap<String, String>();
    private transient AoSentence sentence;
    private transient DataAtom atom;

    private DataTpl() {
    }

    public static DataTpl create() {
        return new DataTpl();
    }

    public String identifier() {
        return Objects.isNull((Object)this.atom) ? null : this.atom.identifier();
    }

    public DataTpl on(AoSentence sentence) {
        this.sentence = sentence;
        return this;
    }

    public DataTpl on(DataAtom atom) {
        this.atom = atom;
        return this;
    }

    DataKey createKey() {
        DataKey key = this.atom.model().key();
        return key.cloneKey();
    }

    HRecord createRecord() {
        return Ao.record(this.atom);
    }

    public MJoin joinLeader() {
        if (ModelType.JOINED != this.atom.model().type()) {
            return null;
        }
        Set<MJoin> joins = this.atom.model().dbJoins();
        MJoin join = joins.stream().filter(item -> Objects.nonNull(item.getPriority())).filter(item -> 0 < item.getPriority()).min(Comparator.comparing(MJoin::getPriority)).orElse(null);
        return Objects.isNull(join) ? null : join;
    }

    public ConcurrentMap<String, String> joinVoters(Predicate<MJoin> predicate) {
        ConcurrentHashMap<String, String> pointer = new ConcurrentHashMap<String, String>();
        this.atom.model().dbJoins().stream().filter(predicate).forEach(join -> pointer.put(join.getEntity(), join.getEntityKey()));
        return pointer;
    }

    public ConcurrentMap<String, String> joinVoters() {
        return this.joinVoters(join -> true);
    }

    public Schema schema(String identifier) {
        Model model = this.atom.model();
        return model.schema(identifier);
    }

    public String column(String field) {
        return this.tpl.values().stream().filter(matrix -> Objects.nonNull(matrix.getColumn(field))).map(matrix -> matrix.getColumn(field)).findAny().orElse(null);
    }

    public ConcurrentMap<String, DataMatrix> matrixData() {
        return this.tpl;
    }

    ConcurrentMap<String, DataMatrix> matrixKey() {
        return this.getKey().getMatrix();
    }

    public DataKey getKey() {
        return this.atom.model().key();
    }

    public DataAtom atom() {
        return this.atom;
    }

    public void initTpl(Schema schema, MField field, MAttribute attribute) {
        String tableName = schema.getTable();
        this.initMatrix(schema, field, attribute).accept(this.tpl);
        this.sources.put(attribute.getName(), tableName);
    }

    public void initKey(Schema schema, MField field, MAttribute attribute) {
        DataKey key = this.getKey();
        if (null != key) {
            this.initMatrix(schema, field, attribute).accept(key.getMatrix());
        }
    }

    private Consumer<ConcurrentMap<String, DataMatrix>> initMatrix(Schema schema, MField field, MAttribute attribute) {
        return tpl -> {
            String tableName = schema.getTable();
            DataMatrix matrix = (DataMatrix)Cc.pool((ConcurrentMap)tpl, (Object)tableName, DataMatrix::create);
            if (null != this.sentence) {
                matrix.on(this.sentence);
            }
            matrix.add(field, attribute);
        };
    }

    public void appendConsole(StringBuilder buffer) {
        this.sources.forEach((attribute, tableName) -> buffer.append(String.format("%-20s", attribute)).append(String.format("%-20s", tableName)).append("\n"));
        DataKey key = this.getKey();
        if (null != key) {
            buffer.append("\n [Key] \u4e3b\u952e\uff0cDataMatrix -> : \n");
            key.getMatrix().forEach((table, matrix) -> {
                buffer.append("\u8868\u540d\uff1a").append((String)table).append("\n");
                matrix.appendConsole(buffer);
                buffer.append("\n");
            });
        }
        buffer.append("[Table] \u8868\uff0c DataMatrix -> \uff1a\n");
        this.tpl.forEach((table, matrix) -> {
            buffer.append("\u8868\u540d\uff1a").append((String)table).append("\n");
            matrix.appendConsole(buffer);
            buffer.append("\n");
        });
    }
}

