/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.builtin;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MField;
import cn.vertxup.atom.domain.tables.pojos.MJoin;
import cn.vertxup.atom.domain.tables.pojos.MModel;
import io.aeon.experiment.rule.RuleUnique;
import io.aeon.experiment.shape.AbstractHModel;
import io.horizon.atom.app.KApp;
import io.horizon.eon.em.modeler.ModelType;
import io.horizon.specification.modeler.HAttribute;
import io.horizon.specification.modeler.HReference;
import io.horizon.specification.typed.TJson;
import io.horizon.uca.cache.Cc;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.modeling.builtin.AtomAttribute;
import io.vertx.tp.atom.modeling.builtin.AtomReference;
import io.vertx.tp.atom.modeling.builtin.Bridge;
import io.vertx.tp.atom.modeling.builtin.DataSchema;
import io.vertx.tp.atom.modeling.element.DataKey;
import io.vertx.tp.modular.apply.AoDefault;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DataModel
extends AbstractHModel
implements Model {
    private final transient Set<Schema> schemata = new HashSet<Schema>();
    private final transient Set<MJoin> joins = new HashSet<MJoin>();
    private final ConcurrentMap<String, MAttribute> attributes = new ConcurrentHashMap<String, MAttribute>();
    private transient MModel model;
    private transient DataKey key;

    public DataModel(KApp app) {
        super(app);
    }

    protected ConcurrentMap<String, HAttribute> loadAttribute() {
        ConcurrentHashMap<String, HAttribute> attrMap = new ConcurrentHashMap<String, HAttribute>();
        this.dbAttributes().forEach(attribute -> {
            Schema schema = this.schema(attribute.getSource());
            MField field = Objects.isNull(schema) ? null : schema.getField(attribute.getSourceField());
            Cc.pool((ConcurrentMap)attrMap, (Object)attribute.getName(), () -> new AtomAttribute((MAttribute)attribute, field));
        });
        return attrMap;
    }

    public HReference reference() {
        return new AtomReference(this, this.app);
    }

    protected boolean trackable() {
        Boolean isTrack = this.dbModel().getIsTrack();
        return Objects.isNull(isTrack) ? Boolean.TRUE : isTrack;
    }

    protected RuleUnique loadRule() {
        String content = this.model.getRuleUnique();
        if (Ut.isNotNil((String)content)) {
            return (RuleUnique)Ut.deserialize((String)content, RuleUnique.class);
        }
        return null;
    }

    @Override
    public MModel dbModel() {
        return this.model;
    }

    @Override
    public Schema schema(String identifier) {
        return Ut.isNil((String)identifier) ? null : (Schema)this.schemata.stream().filter(schema -> identifier.equals(schema.identifier())).findFirst().orElse(null);
    }

    @Override
    public Set<Schema> schema() {
        return this.schemata;
    }

    @Override
    public DataKey key() {
        return this.key;
    }

    @Override
    public void key(DataKey key) {
        this.key = key;
    }

    public ModelType type() {
        String typeStr = this.model.getType();
        ModelType type = (ModelType)Ut.toEnum((String)typeStr, ModelType.class);
        return null == type ? ModelType.DIRECT : type;
    }

    @Override
    public Set<MAttribute> dbAttributes() {
        return new HashSet<MAttribute>(this.attributes.values());
    }

    @Override
    public MAttribute dbAttribute(String attributeName) {
        return (MAttribute)this.attributes.get(attributeName);
    }

    @Override
    public Model bind(Set<Schema> schemas) {
        if (!this.joins.isEmpty()) {
            Bridge.connect((Model)this, schemas);
            this.initialize();
        }
        return this;
    }

    @Override
    public Set<MJoin> dbJoins() {
        return this.joins;
    }

    public void connect(String key) {
        this.model.setKey(key);
        this.attributes.values().forEach(attribute -> attribute.setModelId(key));
    }

    @Override
    public void bindDirect(Set<Schema> schemas) {
        Bridge.connect((Model)this, schemas);
    }

    public void fromJson(JsonObject json) {
        this.attributes.clear();
        this.joins.clear();
        this.schemata.clear();
        JsonObject model = json.getJsonObject("model");
        AoDefault.model().applyJson(model);
        Object uniqueRef = model.getValue("ruleUnique");
        if (uniqueRef instanceof JsonObject) {
            JsonObject content = (JsonObject)uniqueRef;
            this.unique = (RuleUnique)Ut.deserialize((JsonObject)content, RuleUnique.class);
            model.put("ruleUnique", (Object)content.encode());
        }
        this.model = (MModel)Ut.deserialize((JsonObject)model, MModel.class);
        this.model.setNamespace(this.app.ns());
        this.identifier = this.model.getIdentifier();
        JsonArray attributes = json.getJsonArray("attributes");
        Ut.itJArray((JsonArray)attributes, (attribute, index) -> {
            AoDefault.attribute().mount(this.model).applyJson((JsonObject)attribute);
            MAttribute attributeObj = (MAttribute)Ut.deserialize((JsonObject)attribute, MAttribute.class);
            if (Ut.isNotNil((String)attributeObj.getName())) {
                this.attributes.put(attributeObj.getName(), attributeObj);
            }
        });
        JsonArray joins = json.getJsonArray("joins");
        Ut.itJArray((JsonArray)joins, (join, index) -> {
            AoDefault.join().mount(this.model).applyJson((JsonObject)join);
            MJoin joinObj = (MJoin)Ut.deserialize((JsonObject)join, MJoin.class);
            this.joins.add(joinObj);
        });
        JsonArray schemata = json.getJsonArray("schema");
        if (null != schemata) {
            Ut.itJArray((JsonArray)schemata, (schema, index) -> {
                DataSchema schemaObj = new DataSchema(this.app.ns());
                schemaObj.fromJson((JsonObject)schema);
                this.schemata.add(schemaObj);
            });
            Bridge.connect((Model)this, this.app.keyUnique(this.identifier));
            this.initialize();
        }
    }

    public JsonObject toJson() {
        JsonObject content = new JsonObject();
        JsonObject model = (JsonObject)Ut.serializeJson((Object)this.model);
        Object uniqueRef = model.getValue("ruleUnique");
        if (uniqueRef instanceof String) {
            model.put("ruleUnique", (Object)new JsonObject((String)uniqueRef));
        }
        content.put("model", (Object)model);
        JsonArray attributes = (JsonArray)Ut.serializeJson(this.attributes.values());
        content.put("attributes", (Object)attributes);
        JsonArray joins = (JsonArray)Ut.serializeJson(this.joins);
        content.put("joins", (Object)joins);
        JsonArray schemata = new JsonArray();
        this.schemata.stream().map(TJson::toJson).forEach(arg_0 -> ((JsonArray)schemata).add(arg_0));
        content.put("schema", (Object)schemata);
        return content;
    }

    public String toString() {
        StringBuilder content = new StringBuilder();
        content.append("-- Model Begin ------------------------------");
        content.append("\nfile = ").append(this.jsonFile);
        content.append("\nidentifier = ").append(this.identifier);
        content.append("\nnamespace = ").append(this.app.ns());
        content.append("\n\t").append(this.model.toString());
        content.append("\nattributes :");
        this.attributes.forEach((k, v) -> content.append("\n\t").append((String)k).append(" = ").append(v.toString()));
        content.append("\nschemas : [");
        this.schemata.forEach(schema -> content.append("\n").append(schema.toString()));
        content.append("\n]\njoins :");
        this.joins.forEach(item -> content.append("\n\t").append(this.identifier).append("=").append(item.getEntity()).append(",").append(item.getEntityKey()));
        content.append("\n-- Model End --------------------------------\n");
        return content.toString();
    }
}

