/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.builtin;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import io.aeon.experiment.mu.KReference;
import io.aeon.experiment.shape.HAtomReference;
import io.horizon.atom.app.KApp;
import io.horizon.eon.em.modeler.AttributeType;
import io.horizon.specification.modeler.HAtom;
import io.horizon.specification.modeler.HAttribute;
import io.horizon.specification.modeler.HDao;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;

class AtomReference
extends HAtomReference {
    public AtomReference(Model modelRef, KApp app) {
        super(app);
        Set<MAttribute> attributes = modelRef.dbAttributes();
        attributes.stream().filter(Objects::nonNull).filter(attr -> Objects.nonNull(attr.getSource())).filter(attr -> !modelRef.identifier().equals(attr.getSource())).forEach(attribute -> {
            AttributeType type = (AttributeType)Ut.toEnum(attribute::getType, AttributeType.class, (Enum)AttributeType.INTERNAL);
            if (AttributeType.REFERENCE == type) {
                HAttribute aoAttr = modelRef.attribute(attribute.getName());
                KReference reference = new KReference();
                reference.name(attribute.getName());
                reference.source(attribute.getSource()).sourceField(attribute.getSourceField()).sourceReference(attribute.getSourceReference());
                this.initializeReference(reference, aoAttr);
            }
        });
    }

    protected HDao toDao(HAtom atom) {
        return Ao.toDao(atom);
    }

    protected HAtom toAtom(String identifier) {
        return Ao.toAtom(this.app.name(), identifier);
    }
}

