/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.builtin;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MField;
import io.aeon.experiment.mu.KAttribute;
import io.aeon.experiment.mu.KTag;
import io.horizon.eon.em.modeler.AttributeType;
import io.horizon.eon.em.typed.DataFormat;
import io.horizon.specification.modeler.HAttribute;
import io.horizon.specification.modeler.HRule;
import io.modello.atom.typed.MetaField;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.KName;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class AtomAttribute
implements HAttribute,
Serializable {
    private final KAttribute attribute;

    public AtomAttribute(MAttribute attribute, MField sourceField) {
        JsonArray fields;
        Class<Object> configType;
        JsonObject attributeJ = new JsonObject();
        attributeJ.put("name", (Object)attribute.getName());
        attributeJ.put("alias", (Object)attribute.getAlias());
        AttributeType type = (AttributeType)Ut.toEnum(attribute::getType, AttributeType.class, (Enum)AttributeType.INTERNAL);
        Boolean isArray = Objects.isNull(attribute.getIsArray()) ? Boolean.FALSE : attribute.getIsArray();
        JsonObject config = Ut.toJObject((String)attribute.getSourceConfig());
        JsonObject reference = Ut.toJObject((String)attribute.getSourceReference());
        DataFormat format = (DataFormat)Ut.toEnum(() -> config.getString("format"), DataFormat.class, (Enum)DataFormat.Elementary);
        if (isArray.booleanValue()) {
            format = DataFormat.JsonArray;
        }
        attributeJ.put("format", (Object)format);
        if (DataFormat.Elementary == format) {
            configType = Ut.clazz((String)config.getString("type"), String.class);
        } else {
            Class<Object> clazz = configType = DataFormat.JsonArray == format ? JsonArray.class : JsonObject.class;
        }
        Class<Object> attributeType = AttributeType.INTERNAL == type ? (KName.Modeling.VALUE_SET.contains(attribute.getSourceField()) ? configType : (Objects.isNull(sourceField) ? null : Ut.clazz((String)sourceField.getType(), null))) : configType;
        if (Objects.nonNull(attributeType)) {
            attributeJ.put("type", (Object)attributeType.getName());
        }
        if (Ut.isNotNil((JsonArray)(fields = Ut.valueJArray((JsonArray)config.getJsonArray("fields"))))) {
            attributeJ.put("fields", (Object)fields);
        }
        if (reference.containsKey("rule")) {
            JsonObject ruleData = Ut.valueJObject((JsonObject)reference.getJsonObject("rule"));
            attributeJ.put("rule", (Object)ruleData);
        }
        KTag matrix = this.initializeMatrix(attribute);
        this.attribute = new KAttribute(attributeJ, matrix);
    }

    private KTag initializeMatrix(MAttribute attribute) {
        StringBuilder literal = new StringBuilder();
        ArrayList<Boolean> values = new ArrayList<Boolean>();
        values.add(attribute.getActive());
        values.add(attribute.getIsTrack());
        values.add(attribute.getIsLock());
        values.add(attribute.getIsConfirm());
        values.add(attribute.getIsArray());
        values.add(attribute.getIsSyncIn());
        values.add(attribute.getIsSyncOut());
        values.add(attribute.getIsRefer());
        for (int idx = 0; idx < values.size(); ++idx) {
            Boolean value = (Boolean)values.get(idx);
            if (Objects.isNull(value)) {
                literal.append("NULL");
            } else {
                literal.append(value);
            }
            if (idx >= values.size() - 1) continue;
            literal.append(",");
        }
        return new KTag(literal.toString());
    }

    public MetaField field() {
        return this.attribute.field();
    }

    public List<MetaField> fields() {
        return this.attribute.fields();
    }

    public KTag tag() {
        return this.attribute.tag();
    }

    public HRule refRule() {
        return this.attribute.refRule();
    }

    public DataFormat format() {
        return this.attribute.format();
    }
}

