/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.ambient;

import cn.vertxup.atom.domain.tables.daos.MEntityDao;
import cn.vertxup.atom.domain.tables.daos.MFieldDao;
import cn.vertxup.atom.domain.tables.daos.MKeyDao;
import cn.vertxup.atom.domain.tables.pojos.MEntity;
import cn.vertxup.atom.domain.tables.pojos.MField;
import cn.vertxup.atom.domain.tables.pojos.MKey;
import io.horizon.spi.ambient.AoRefine;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.jdbc.Pin;
import io.vertx.tp.modular.metadata.AoBuilder;
import io.vertx.up.commune.config.Database;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

class SchemaRefine
implements AoRefine {
    SchemaRefine() {
    }

    public Function<JsonObject, Future<JsonObject>> apply() {
        return appJson -> {
            JsonArray models = appJson.getJsonArray("models");
            String name = appJson.getString("name");
            Set<Schema> schemata = this.toSchemata(models, name);
            Ao.LOG.Uca.info(this.getClass(), "2. AoRefine.schema(): {0}", new Object[]{String.valueOf(schemata.size())});
            JsonObject source = appJson.getJsonObject("source");
            this.syncDatabase(source, schemata);
            ArrayList futures = new ArrayList();
            schemata.stream().map(this::saveSchema).forEach(futures::add);
            return Fn.combineA(futures).compose(nil -> Ux.future((Object)appJson)).otherwise(Ux.otherwise(() -> null));
        };
    }

    private void syncDatabase(JsonObject source, Set<Schema> schemata) {
        Database database = new Database();
        database.fromJson(source);
        Ao.LOG.Uca.info(this.getClass(), "Database Extraction: {0}", new Object[]{database.toJson()});
        Pin pin = Pin.getInstance();
        AoBuilder builder = pin.getBuilder(database);
        schemata.forEach(builder::synchron);
    }

    private Set<Schema> toSchemata(JsonArray models, String appName) {
        HashSet<Schema> schemata = new HashSet<Schema>();
        Ut.itJArray((JsonArray)models).map(data -> Ao.toModel(appName, data)).map(Model::schema).forEach(schemata::addAll);
        return schemata;
    }

    private JsonObject criteria(String name, MEntity entity) {
        JsonObject filters = new JsonObject();
        filters.put("name", (Object)name);
        filters.put("entityId", (Object)entity.getKey());
        filters.put("", (Object)Boolean.TRUE);
        return filters;
    }

    private Set<String> uniqueSet() {
        return new HashSet<String>(){
            {
                this.add("name");
                this.add("entityId");
            }
        };
    }

    private JsonObject criteria(MEntity entity) {
        JsonObject filters = new JsonObject();
        filters.put("namespace", (Object)entity.getNamespace());
        filters.put("identifier", (Object)entity.getIdentifier());
        filters.put("", (Object)Boolean.TRUE);
        return filters;
    }

    private Future<JsonObject> saveSchema(Schema schema) {
        MEntity updated = schema.getEntity();
        return Ux.Jooq.on(MEntityDao.class).upsertAsync(this.criteria(updated), (Object)updated).compose(entity -> {
            schema.connect(entity.getKey());
            ArrayList<Future<JsonArray>> combine = new ArrayList<Future<JsonArray>>();
            combine.add(this.saveField(schema, (MEntity)entity));
            combine.add(this.saveKey(schema, (MEntity)entity));
            return Fn.compressA(combine).compose(nil -> Ux.future((Object)entity)).compose(Ux::futureJ).otherwise(Ux.otherwise(() -> null));
        });
    }

    private Future<JsonArray> saveKey(Schema schema, MEntity entity) {
        JsonObject condition = new JsonObject();
        MKey[] keys = schema.getKeys();
        for (int idx = 0; idx < keys.length; ++idx) {
            MKey field = keys[idx];
            condition.put("$" + idx, (Object)this.criteria(field.getName(), entity));
        }
        UxJooq jq = Ux.Jooq.on(MKeyDao.class);
        return jq.fetchAsync(condition).compose(queried -> {
            List<MKey> fieldList = Arrays.asList(keys);
            ConcurrentMap compared = Ux.compare((List)queried, fieldList, this.uniqueSet());
            return Ux.compareRun((ConcurrentMap)compared, arg_0 -> ((UxJooq)jq).insertAsync(arg_0), arg_0 -> ((UxJooq)jq).updateAsync(arg_0));
        });
    }

    private Future<JsonArray> saveField(Schema schema, MEntity entity) {
        JsonObject condition = new JsonObject();
        MField[] fields = schema.getFields();
        for (int idx = 0; idx < fields.length; ++idx) {
            MField field = fields[idx];
            condition.put("$" + idx, (Object)this.criteria(field.getName(), entity));
        }
        UxJooq jq = Ux.Jooq.on(MFieldDao.class);
        return jq.fetchAsync(condition).compose(queried -> {
            List<MField> fieldList = Arrays.asList(fields);
            ConcurrentMap compared = Ux.compare((List)queried, fieldList, this.uniqueSet());
            return Ux.compareRun((ConcurrentMap)compared, arg_0 -> ((UxJooq)jq).insertAsync(arg_0), arg_0 -> ((UxJooq)jq).updateAsync(arg_0));
        });
    }
}

