/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.environment;

import cn.vertxup.ambient.domain.tables.daos.XAppDao;
import cn.vertxup.ambient.domain.tables.daos.XSourceDao;
import cn.vertxup.ambient.domain.tables.pojos.XApp;
import cn.vertxup.ambient.domain.tables.pojos.XSource;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.up.commune.config.Database;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Configuration;

class UnityAsker {
    private static final Annal LOGGER = Annal.get(UnityAsker.class);
    private static final ConcurrentMap<String, XApp> APP_POOL = new ConcurrentHashMap<String, XApp>();
    private static final ConcurrentMap<String, XSource> SOURCE_POOL = new ConcurrentHashMap<String, XSource>();

    UnityAsker() {
    }

    static void init() {
        XAppDao appDao = (XAppDao)((Object)Ut.singleton(XAppDao.class, (Object[])new Object[]{UnityAsker.getConfiguration()}));
        List applications = appDao.findAll();
        At.infoApp(LOGGER, "{0} Application have been initialized successfully!", applications.size());
        XSourceDao sourceDao = (XSourceDao)((Object)Ut.singleton(XSourceDao.class, (Object[])new Object[]{UnityAsker.getConfiguration()}));
        List sources = sourceDao.findAll();
        At.infoApp(LOGGER, "{0} Data source have been initialized successfully!", sources.size());
        APP_POOL.putAll(Ut.elementZip((Collection)applications, XApp::getKey, app -> app));
        SOURCE_POOL.putAll(Ut.elementZip((Collection)sources, XSource::getAppId, source -> source));
    }

    private static Configuration getConfiguration() {
        Database database = Database.getCurrent();
        DataPool pool = DataPool.create((Database)database);
        return pool.getExecutor().configuration();
    }

    static ConcurrentMap<String, XApp> getApps() {
        return APP_POOL;
    }

    static ConcurrentMap<String, XSource> getSources() {
        return SOURCE_POOL;
    }
}

