/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.environment;

import cn.vertxup.ambient.domain.tables.pojos.XApp;
import cn.vertxup.ambient.domain.tables.pojos.XSource;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.optic.environment.UnityApp;
import io.vertx.tp.optic.environment.UnityAsker;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UnityAmbient
implements UnityApp {
    private static final ConcurrentMap<String, JsonObject> UNITY_POOL = new ConcurrentHashMap<String, JsonObject>();

    public void initialize() {
        UnityAsker.init();
        ConcurrentMap<String, XApp> apps = UnityAsker.getApps();
        ConcurrentMap<String, XSource> sources = UnityAsker.getSources();
        apps.keySet().stream().filter(appId -> Objects.nonNull(apps.get(appId))).filter(appId -> Objects.nonNull(sources.get(appId))).map(appId -> this.connect((XApp)apps.get(appId), (XSource)sources.get(appId))).forEach(item -> UNITY_POOL.put(item.getString("appId"), (JsonObject)item));
    }

    public ConcurrentMap<String, JsonObject> connect() {
        return UNITY_POOL;
    }

    private JsonObject connect(XApp app, XSource source) {
        JsonObject normalized = new JsonObject();
        normalized.put("appId", app.getKey());
        normalized.put("appKey", app.getAppKey());
        normalized.put("sigma", app.getSigma());
        normalized.put("name", app.getName());
        normalized.put("code", app.getCode());
        normalized.put("language", app.getLanguage());
        normalized.put("active", app.getActive());
        normalized.put("logo", app.getLogo());
        normalized.put("title", app.getTitle());
        JsonObject business = new JsonObject();
        business.put("icp", app.getIcp());
        business.put("email", app.getEmail());
        business.put("copyRight", app.getCopyRight());
        normalized.put("business", business);
        JsonObject backend = new JsonObject();
        backend.put("domain", app.getDomain());
        backend.put("appPort", app.getAppPort());
        backend.put("route", app.getRoute());
        normalized.put("backend", backend);
        JsonObject frontend = new JsonObject();
        frontend.put("path", app.getPath());
        frontend.put("urlEntry", app.getUrlEntry());
        frontend.put("urlMain", app.getUrlMain());
        normalized.put("frontend", frontend);
        JsonObject auditor = new JsonObject();
        auditor.put("createdBy", app.getCreatedBy());
        Fn.safeNull(() -> auditor.put("createdAt", Ut.parse((LocalDateTime)app.getCreatedAt()).toInstant()), (Object[])new Object[]{app.getCreatedAt()});
        auditor.put("updatedBy", app.getUpdatedBy());
        Fn.safeNull(() -> auditor.put("updatedAt", Ut.parse((LocalDateTime)app.getUpdatedAt()).toInstant()), (Object[])new Object[]{app.getUpdatedAt()});
        normalized.put("auditor", auditor);
        JsonObject sourceJson = new JsonObject();
        sourceJson.put("hostname", source.getHostname());
        sourceJson.put("instance", source.getInstance());
        sourceJson.put("port", source.getPort());
        sourceJson.put("category", source.getCategory());
        sourceJson.put("jdbcUrl", source.getJdbcUrl());
        sourceJson.put("username", source.getUsername());
        sourceJson.put("password", source.getPassword());
        sourceJson.put("driverClassName", source.getDriverClassName());
        String jdbcConfig = source.getJdbcConfig();
        if (Ut.notNil((String)jdbcConfig)) {
            sourceJson.put("options", Ut.toJObject((String)jdbcConfig));
        }
        normalized.put("source", sourceJson);
        return normalized;
    }
}

