/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.init;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class AtTodo {
    private static final Annal LOGGER = Annal.get(AtTodo.class);
    private static final ConcurrentMap<String, JsonObject> TODO_DEF = new ConcurrentHashMap<String, JsonObject>();

    AtTodo() {
    }

    static void init() {
        if (TODO_DEF.isEmpty()) {
            List files = Ut.ioFiles((String)"plugin/ambient/todo/", (String)"json");
            At.infoInit(LOGGER, "At Todo Files: {0}", files.size());
            files.forEach(file -> {
                String path = "plugin/ambient/todo/" + file;
                JsonObject todoDef = Ut.ioJObject((String)path);
                String key = file.replace(".json", "");
                TODO_DEF.put(key, todoDef);
            });
        }
    }

    static JsonObject getTodo(String type) {
        JsonObject todoDef = (JsonObject)TODO_DEF.get(type);
        return Objects.isNull(todoDef) ? new JsonObject() : todoDef.copy();
    }
}

