/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.inquire;

import io.vertx.up.annotations.Authenticate;
import io.vertx.up.annotations.Authorize;
import io.vertx.up.atom.secure.Cliff;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.zero.exception.WallMethodMultiException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;

public class PhylumAuth {
    private final transient Class<?> clazz;
    private final transient Annal logger;
    private final transient Method[] methods;

    public static PhylumAuth create(Class<?> clazz) {
        return new PhylumAuth(clazz);
    }

    private PhylumAuth(Class<?> clazz) {
        this.clazz = clazz;
        this.logger = Annal.get(clazz);
        this.methods = clazz.getDeclaredMethods();
    }

    public PhylumAuth verify() {
        Fn.flingUp((boolean)this.verifyMethod(this.methods, Authenticate.class), (Annal)this.logger, WallMethodMultiException.class, (Object[])new Object[]{this.getClass(), Authenticate.class.getSimpleName(), this.clazz.getName()});
        Fn.flingUp((boolean)this.verifyMethod(this.methods, Authorize.class), (Annal)this.logger, WallMethodMultiException.class, (Object[])new Object[]{this.getClass(), Authorize.class.getSimpleName(), this.clazz.getName()});
        return this;
    }

    public void mount(Cliff reference) {
        reference.setProxy(Instance.instance(this.clazz, (Object[])new Object[0]));
        Optional<Method> authenticateMethod = Arrays.stream(this.methods).filter(item -> item.isAnnotationPresent(Authenticate.class)).findFirst();
        reference.getAuthorizer().setAuthenticate(authenticateMethod.orElse(null));
        Optional<Method> authorizeMethod = Arrays.stream(this.methods).filter(item -> item.isAnnotationPresent(Authorize.class)).findFirst();
        reference.getAuthorizer().setAuthorize(authorizeMethod.orElse(null));
    }

    private boolean verifyMethod(Method[] methods, Class<? extends Annotation> clazz) {
        long found = Arrays.stream(methods).filter(method -> method.isAnnotationPresent(clazz)).count();
        return 1L < found;
    }
}

