/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.hunt;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.up.annotations.SessionData;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.rs.hunt.Normalizer;
import io.vertx.up.tool.StringUtil;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.tool.mirror.Types;
import java.lang.reflect.Method;

public final class Answer {
    public static void reply(RoutingContext context, Envelop envelop) {
        HttpServerResponse response = context.response();
        HttpStatusCode code = envelop.status();
        response.setStatusCode(code.code());
        response.setStatusMessage(code.message());
        response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
        if (!response.ended()) {
            response.end(envelop.response());
        }
        response.close();
    }

    public static void reply(RoutingContext context, Envelop envelop, Event event) {
        HttpServerResponse response = context.response();
        HttpStatusCode code = envelop.status();
        response.setStatusCode(code.code());
        response.setStatusMessage(code.message());
        Normalizer.out(response, envelop, event);
        Answer.storeSession(context, envelop.data(), event.getAction());
        if (!response.ended()) {
            response.end(envelop.response());
        }
        response.close();
    }

    private static <T> void storeSession(RoutingContext context, T data, Method method) {
        Session session = context.session();
        if (null != session && null != data && method.isAnnotationPresent(SessionData.class)) {
            SessionData annotation = method.getAnnotation(SessionData.class);
            String key = (String)Instance.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
            String field = (String)Instance.invoke((Object)annotation, (String)"field", (Object[])new Object[0]);
            Object reference = data;
            if (Types.isJObject(data) && StringUtil.notNil((String)field)) {
                JsonObject target = (JsonObject)data;
                reference = target.getValue(field);
            }
            session.put(key, reference);
        }
    }
}

