/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.up.annotations.Ipc;
import io.vertx.up.annotations.Worker;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.worker.Receipt;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.follow.Invoker;
import io.vertx.up.micro.follow.JetSelector;
import io.vertx.up.web.ZeroAnno;
import io.vertx.zero.exception.WorkerArgumentException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

@Worker
public class ZeroHttpWorker
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroHttpWorker.class);
    private static final Set<Receipt> RECEIPTS = ZeroAnno.getReceipts();
    private static final ConcurrentMap<Integer, Invoker> INVOKER_MAP = new ConcurrentHashMap<Integer, Invoker>();
    private static final AtomicBoolean LOGGED = new AtomicBoolean(Boolean.FALSE);

    public void start() {
        EventBus bus = this.vertx.eventBus();
        for (Receipt receipt : RECEIPTS) {
            String address = receipt.getAddress();
            Object reference = receipt.getProxy();
            Method method = receipt.getMethod();
            this.verifyArgs(method, ((Object)((Object)this)).getClass());
            Class<?>[] params = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            Class<?> paramCls = params[0];
            Invoker invoker = JetSelector.select(returnType, paramCls);
            invoker.ensure(returnType, paramCls);
            INVOKER_MAP.put(receipt.hashCode(), invoker);
            Fn.safeJvm(() -> Fn.safeNull(() -> bus.consumer(address, message -> {
                if (method.isAnnotationPresent(Ipc.class)) {
                    invoker.next(reference, method, (Message<Envelop>)message, this.vertx);
                } else {
                    invoker.invoke(reference, method, (Message<Envelop>)message);
                }
            }), (Object[])new Object[]{address, reference, method}), (Annal)LOGGER);
        }
        if (!LOGGED.getAndSet(Boolean.TRUE)) {
            INVOKER_MAP.forEach((key, value) -> LOGGER.info("[ ZERO ] ( Invoker ) Zero system selected {0} as invoker,the metadata receipt hash code = {1}, invoker hash code ={2}.", new Object[]{value.getClass(), String.valueOf(key), String.valueOf(value.hashCode())}));
        }
    }

    private void verifyArgs(Method method, Class<?> target) {
        Class<?>[] params = method.getParameterTypes();
        Annal logger = Annal.get(target);
        Fn.flingUp((1 != params.length ? 1 : 0) != 0, (Annal)logger, WorkerArgumentException.class, (Object[])new Object[]{target, method});
    }
}

