/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro;

import io.netty.util.internal.ConcurrentSet;
import io.reactivex.Observable;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.up.annotations.Worker;
import io.vertx.up.concurrent.Runner;
import io.vertx.up.eon.em.MessageModel;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.discovery.EndPointOrigin;
import io.vertx.up.micro.discovery.Origin;
import io.vertx.up.tool.mirror.Instance;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

@Worker(value=MessageModel.DISCOVERY_PUBLISH, instances=2)
public class ZeroApiWorker
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroApiWorker.class);
    private static final Origin ORIGIN = (Origin)Instance.singleton(EndPointOrigin.class, (Object[])new Object[0]);
    private static final ConcurrentMap<String, Record> REGISTRITIONS = new ConcurrentHashMap<String, Record>();
    private static final ConcurrentMap<String, String> ID_MAP = new ConcurrentHashMap<String, String>();
    private static final ConcurrentSet<String> REGISTRY = new ConcurrentSet();
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    public void start() {
        ServiceDiscovery discovery = ServiceDiscovery.create((Vertx)this.vertx);
        if (!initialized.getAndSet(true)) {
            this.initializeServices(discovery);
        }
        this.vertx.setPeriodic(3000L, id -> {
            ConcurrentMap<String, Record> services = ORIGIN.getRegistryData();
            ConcurrentMap<Flag, Set<String>> resultMap = this.calculateServices(services);
            Fn.safeJvm(() -> {
                CountDownLatch counter = new CountDownLatch(3);
                Set deleted = (Set)resultMap.get((Object)Flag.DELETE);
                Set updated = (Set)resultMap.get((Object)Flag.UPDATE);
                Set added = (Set)resultMap.get((Object)Flag.NEW);
                Runner.run(() -> {
                    this.deleteService(discovery, deleted);
                    counter.countDown();
                }, (String)"discovery-deleted");
                Runner.run(() -> {
                    this.updateService(discovery, updated);
                    counter.countDown();
                }, (String)"discovery-updated");
                Runner.run(() -> {
                    this.addService(discovery, added, services);
                    counter.countDown();
                }, (String)"discovery-added");
                counter.await();
                LOGGER.info("[ ZERO ] ( Discovery ) Records ( added = {0}, updated = {1}, deleted = {2} ) have been refreshed! ", new Object[]{added.size(), updated.size(), deleted.size()});
            }, (Annal)LOGGER);
        });
    }

    private void deleteService(ServiceDiscovery discovery, Set<String> ids) {
        Observable.fromIterable(ids).subscribe(id -> {
            String item = (String)ID_MAP.get(id);
            discovery.unpublish(item, result -> {
                if (result.succeeded()) {
                    Record record = (Record)REGISTRITIONS.get(id);
                    this.successLog(record);
                    REGISTRITIONS.remove(id);
                    ID_MAP.remove(id);
                    REGISTRY.remove(id);
                } else {
                    LOGGER.info("[ ZERO ] ( Discovery ) Action: {1}, Service Registration has met error: {0}.", new Object[]{result.cause().getMessage(), "Delete"});
                }
            });
        });
    }

    private void updateService(ServiceDiscovery discovery, Set<String> ids) {
        Observable.fromIterable(ids).map(REGISTRITIONS::get).subscribe(item -> discovery.update(item, result -> {
            if (result.succeeded()) {
                Record record = (Record)result.result();
                this.successFinished(record);
            } else {
                LOGGER.info("[ ZERO ] ( Discovery ) Action: {1}, Service Registration has met error: {0}.", new Object[]{result.cause().getMessage(), "Update"});
            }
        }));
    }

    private void addService(ServiceDiscovery discovery, Set<String> ids, ConcurrentMap<String, Record> services) {
        Observable.fromIterable(ids).map(services::get).subscribe(item -> this.publishSerivce(discovery, "Add").accept((Record)item));
    }

    private Consumer<Record> publishSerivce(ServiceDiscovery discovery, String flag) {
        return item -> {
            if (null == item.getRegistration() || !REGISTRY.contains((Object)item.getRegistration())) {
                discovery.publish(item, result -> {
                    if (result.succeeded()) {
                        Record record = (Record)result.result();
                        this.successFinished(record);
                        REGISTRY.add((Object)item.getRegistration());
                    } else {
                        LOGGER.info("[ ZERO ] ( Discovery ) Action: {1}, Service Registration has met error: {0}.", new Object[]{result.cause().getMessage(), flag});
                    }
                });
            }
        };
    }

    private void initializeServices(ServiceDiscovery discovery) {
        HashSet services = new HashSet(ORIGIN.getRegistryData().values());
        Observable.fromIterable(services).subscribe(item -> this.publishSerivce(discovery, "Init").accept((Record)item));
    }

    private ConcurrentMap<Flag, Set<String>> calculateServices(ConcurrentMap<String, Record> services) {
        HashSet populated = new HashSet();
        Observable.fromIterable(services.keySet()).subscribe(populated::add);
        HashSet deleted = new HashSet(REGISTRITIONS.keySet());
        deleted.removeAll(populated);
        HashSet updated = new HashSet(REGISTRITIONS.keySet());
        updated.retainAll(populated);
        HashSet added = new HashSet(populated);
        added.removeAll(REGISTRITIONS.keySet());
        ConcurrentHashMap<Flag, Set<String>> result = new ConcurrentHashMap<Flag, Set<String>>();
        result.put(Flag.DELETE, deleted);
        result.put(Flag.NEW, added);
        result.put(Flag.UPDATE, updated);
        return result;
    }

    private void successFinished(Record record) {
        String key = this.getID(record);
        String id = record.getRegistration();
        this.successLog(record);
        REGISTRITIONS.put(key, record);
        ID_MAP.put(key, id);
    }

    private void successLog(Record record) {
        String key = this.getID(record);
        String id = record.getRegistration();
        String endpoint = MessageFormat.format("http://{0}:{1}{2}", record.getLocation().getString("host"), String.valueOf(record.getLocation().getInteger("port")), record.getMetadata().getString("path"));
        LOGGER.debug("[ ZERO ] ( Discovery ) Record : ( name = {2}, uri = {3} ) key = {4}, id = {5}, status = {0}, type = {1} has been refreshed in Zero system.", new Object[]{record.getStatus(), record.getType(), record.getName(), endpoint, key, id});
    }

    private String getID(Record record) {
        JsonObject metadata = record.getMetadata();
        return metadata.getString("id");
    }

    private static enum Flag {
        NEW,
        UPDATE,
        DELETE;

    }
}

