/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.atom;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Session;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception._500InternalServerException;
import io.vertx.up.func.Fn;
import io.vertx.up.kidd.Readible;
import io.vertx.up.log.Annal;
import io.vertx.up.web.ZeroSerializer;
import io.vertx.zero.exception.IndexExceedException;
import java.io.Serializable;

public class Envelop
implements Serializable {
    private static final Annal LOGGER = Annal.get(Envelop.class);
    private final HttpStatusCode status;
    private MultiMap headers;
    private final WebException error;
    private final JsonObject data;
    private User user;
    private Session session;

    public boolean valid() {
        return null == this.error;
    }

    public <T> T data() {
        if (null != this.data && this.data.containsKey("data")) {
            Object value = this.data.getValue("data");
            if (null != value) {
                return (T)value;
            }
            return null;
        }
        return null;
    }

    public <T> T data(Class<T> clazz) {
        T reference = null;
        if (this.data.containsKey("data")) {
            reference = this.extract(this.data.getValue("data"), clazz);
        }
        return reference;
    }

    public <T> T data(Integer argIndex, Class<T> clazz) {
        String key;
        JsonObject raw;
        T reference = null;
        Fn.flingUp((0 > argIndex ? 1 : 0) != 0, (Annal)LOGGER, IndexExceedException.class, (Object[])new Object[]{this.getClass(), argIndex});
        if (this.data.containsKey("data") && null != (raw = this.data.getJsonObject("data")) && raw.containsKey(key = argIndex.toString())) {
            reference = this.extract(raw.getValue(key), clazz);
        }
        return reference;
    }

    private <T> T extract(Object value, Class<T> clazz) {
        Object reference = null;
        if (null != value) {
            Object result = ZeroSerializer.getValue(clazz, value.toString());
            reference = Fn.get(() -> result, (Object[])new Object[]{result});
        }
        return (T)reference;
    }

    public String response() {
        JsonObject response = null == this.error ? this.data : this.fail(this.error);
        return response.encode();
    }

    public Future<Envelop> toFuture() {
        return Future.succeededFuture((Object)this);
    }

    public HttpStatusCode status() {
        return this.status;
    }

    public User user() {
        return this.user;
    }

    public MultiMap headers() {
        return this.headers;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setHeaders(MultiMap headers) {
        this.headers = headers;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String identifier(String field) {
        return (String)Fn.getJvm((Object)"", () -> {
            JsonObject credential = this.user.principal();
            return (String)Fn.getSemi((null != credential && credential.containsKey(field) ? 1 : 0) != 0, () -> credential.getString(field), () -> "");
        }, (Object[])new Object[]{this.user});
    }

    private <T> Envelop(T data, HttpStatusCode status) {
        this.data = this.build(ZeroSerializer.toSupport(data));
        this.error = null;
        this.status = status;
    }

    private <T> JsonObject build(T input) {
        JsonObject data = new JsonObject();
        HttpStatusCode status = null == this.error ? HttpStatusCode.OK : this.error.getStatus();
        data.put("data", input);
        return data;
    }

    public static Envelop ok() {
        return Envelop.success(null);
    }

    public static <T> Envelop success(T entity) {
        return new Envelop(entity, HttpStatusCode.OK);
    }

    public static <T> Envelop failure(String message) {
        return new Envelop(new _500InternalServerException(Envelop.class, message));
    }

    public static <T> Envelop success(T entity, HttpStatusCode status) {
        return new Envelop(entity, status);
    }

    public static Envelop failure(WebException error) {
        Readible readible = Readible.get();
        readible.interpret(error);
        return new Envelop(error);
    }

    private Envelop(WebException error) {
        this.status = error.getStatus();
        this.error = error;
        this.data = this.fail(error);
    }

    private JsonObject fail(WebException error) {
        return error.toJson();
    }

    public String toString() {
        return "Envelop{status=" + this.status + ", headers=" + this.headers + ", error=" + this.error + ", data=" + this.data + ", user=" + this.user + '}';
    }
}

