/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.github.jklingsporn.vertx.jooq.future.VertxDAO;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.JooqInfix;
import io.vertx.up.aiki.Async;
import io.vertx.up.aiki.Uarr;
import io.vertx.up.aiki.Ux;
import io.vertx.up.atom.query.Criteria;
import io.vertx.up.atom.query.Inquiry;
import io.vertx.up.atom.query.Pager;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.StringUtil;
import io.vertx.up.tool.mirror.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.sf.cglib.beans.BeanCopier;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Operator;
import org.jooq.SelectConditionStep;
import org.jooq.SelectSeekStepN;
import org.jooq.SelectWhereStep;
import org.jooq.SelectWithTiesAfterOffsetStep;
import org.jooq.SortField;
import org.jooq.impl.DSL;

public class UxJooq {
    private static final Annal LOGGER = Annal.get(UxJooq.class);
    private final transient Class<?> clazz;
    private final transient VertxDAO vertxDAO;
    private static final ConcurrentMap<String, BiFunction<String, Object, Condition>> OPS = new ConcurrentHashMap<String, BiFunction<String, Object, Condition>>(){
        {
            this.put("<", (field, value) -> DSL.field((String)field).lt(value));
            this.put(">", (field, value) -> DSL.field((String)field).gt(value));
            this.put("<=", (field, value) -> DSL.field((String)field).le(value));
            this.put(">=", (field, value) -> DSL.field((String)field).ge(value));
            this.put("=", (field, value) -> DSL.field((String)field).eq(value));
            this.put("<>", (field, value) -> DSL.field((String)field).ne(value));
            this.put("!n", (field, value) -> DSL.field((String)field).isNotNull());
            this.put("n", (field, value) -> DSL.field((String)field).isNull());
            this.put("t", (field, value) -> DSL.field((String)field).isTrue());
            this.put("f", (field, value) -> DSL.field((String)field).isFalse());
            this.put("i", (x$0, x$1) -> UxJooq.opIn(x$0, x$1));
            this.put("!i", (x$0, x$1) -> UxJooq.opNotIn(x$0, x$1));
            this.put("s", (field, value) -> DSL.field((String)field).startsWith(value));
            this.put("e", (field, value) -> DSL.field((String)field).endsWith(value));
            this.put("c", (field, value) -> DSL.field((String)field).contains(value));
        }
    };

    <T> UxJooq(Class<T> clazz) {
        this.clazz = clazz;
        this.vertxDAO = (VertxDAO)JooqInfix.getDao(clazz);
    }

    public <T> Future<T> findByIdAsync(Object id) {
        CompletableFuture future = this.vertxDAO.findByIdAsync(id);
        return Async.toFuture(future);
    }

    public <T> Future<List<T>> findAllAsync() {
        CompletableFuture future = this.vertxDAO.findAllAsync();
        return Async.toFuture(future);
    }

    public <T> Future<T> insertAsync(T entity) {
        CompletableFuture future = this.vertxDAO.insertAsync(entity);
        return Future.succeededFuture(entity);
    }

    public <T> Future<T> insertReturningPrimaryAsync(T entity, Consumer<Long> consumer) {
        CompletableFuture future = this.vertxDAO.insertReturningPrimaryAsync(entity);
        return Async.toFuture(future).compose(id -> {
            if (null != consumer) {
                consumer.accept((Long)id);
            }
            return Future.succeededFuture((Object)entity);
        });
    }

    public <T> Future<List<T>> insertAsync(List<T> entities) {
        CompletableFuture future = this.vertxDAO.insertAsync(entities);
        return Future.succeededFuture(entities);
    }

    public <T> Future<T> updateAsync(T entity) {
        CompletableFuture future = this.vertxDAO.updateAsync(entity);
        return Future.succeededFuture(entity);
    }

    public <T> Future<List<T>> updateAsync(List<T> entities) {
        CompletableFuture future = this.vertxDAO.updateAsync(entities);
        return Future.succeededFuture(entities);
    }

    private <T> T copyEntity(T target, T updated) {
        BeanCopier copier = BeanCopier.create(target.getClass(), updated.getClass(), (boolean)false);
        copier.copy(updated, target, null);
        return target;
    }

    public <T> Future<T> saveAsync(Object id, T updated) {
        return this.saveAsync(id, target -> this.copyEntity(target, updated));
    }

    public <T> Future<T> saveAsync(Object id, Function<T, T> copyFun) {
        return this.findByIdAsync(id).compose(old -> this.updateAsync(copyFun.apply(old)));
    }

    public <T> Future<T> upsertReturningPrimaryAsync(JsonObject andFilters, T updated, Consumer<Long> consumer) {
        return this.fetchOneAndAsync(andFilters).compose(item -> Ux.match(Ux.fork(() -> this.updateAsync(this.copyEntity(item, updated))), Ux.branch(null == item, () -> this.insertReturningPrimaryAsync(updated, consumer))));
    }

    public <T> Future<T> upsertAsync(JsonObject andFilters, T updated) {
        return this.fetchOneAndAsync(andFilters).compose(item -> Ux.match(Ux.fork(() -> this.updateAsync(this.copyEntity(item, updated))), Ux.branch(null == item, () -> this.insertAsync(updated))));
    }

    public <T> Future<T> deleteAsync(T entity) {
        CompletableFuture future = this.vertxDAO.deleteAsync(Arrays.asList(entity));
        return Future.succeededFuture(entity);
    }

    public <T> Future<Boolean> deleteByIdAsync(Object id) {
        CompletableFuture future = this.vertxDAO.deleteByIdAsync(id);
        return Future.succeededFuture((Object)Boolean.TRUE);
    }

    public <T> Future<Boolean> deleteByIdAsync(Collection<Object> ids) {
        CompletableFuture future = this.vertxDAO.deleteByIdAsync(ids);
        return Future.succeededFuture((Object)Boolean.TRUE);
    }

    public <T> Future<Boolean> deleteByIdAsync(Object ... ids) {
        CompletableFuture future = this.vertxDAO.deleteByIdAsync(Arrays.asList(ids));
        return Future.succeededFuture((Object)Boolean.TRUE);
    }

    public <T> Future<Boolean> existsByIdAsync(Object id) {
        CompletableFuture future = this.vertxDAO.existsByIdAsync(id);
        return Async.toFuture(future);
    }

    public <T> Future<Boolean> existsOneAsync(JsonObject andFilters) {
        return this.fetchOneAndAsync(andFilters).compose(item -> Future.succeededFuture((Object)(null != item ? 1 : 0)));
    }

    public <T> Future<T> fetchOneAsync(String column, Object value) {
        CompletableFuture future = this.vertxDAO.fetchOneAsync(DSL.field((String)column), value);
        return Async.toFuture(future);
    }

    public <T> Future<T> fetchOneAndAsync(JsonObject andFilters) {
        Condition condition = UxJooq.transform(andFilters, Operator.AND);
        CompletableFuture future = this.vertxDAO.fetchOneAsync(condition);
        return Async.toFuture(future);
    }

    public <T> Future<List<T>> fetchAsync(String column, Object value) {
        CompletableFuture future = this.vertxDAO.fetchAsync(DSL.field((String)column), Arrays.asList(value));
        return Async.toFuture(future);
    }

    public <T> Future<List<T>> fetchInAsync(String column, Object ... value) {
        CompletableFuture future = this.vertxDAO.fetchAsync(DSL.field((String)column), Arrays.asList(value));
        return Async.toFuture(future);
    }

    public <T> Future<List<T>> fetchAndAsync(JsonObject andFilters) {
        Condition condition = UxJooq.transform(andFilters, Operator.AND);
        CompletableFuture future = this.vertxDAO.fetchAsync(condition);
        return Async.toFuture(future);
    }

    public <T> Future<List<T>> fetchOrAsync(JsonObject orFilters) {
        Condition condition = UxJooq.transform(orFilters, Operator.OR);
        CompletableFuture future = this.vertxDAO.fetchAsync(condition);
        return Async.toFuture(future);
    }

    public Future<JsonObject> searchOrAsync(Inquiry inquiry) {
        return this.searchOrAsync(inquiry, "");
    }

    public Future<JsonObject> searchOrAsync(Inquiry inquiry, String pojo) {
        JsonObject result = new JsonObject();
        return this.searchDirect(inquiry, Operator.OR).compose(array -> Ux.thenJsonMore(array.getList(), pojo)).compose(array -> {
            result.put("list", array);
            return this.countSearchAsync(inquiry, Operator.OR);
        }).compose(count -> {
            result.put("count", count);
            return Future.succeededFuture((Object)result);
        });
    }

    public Future<JsonObject> searchAndAsync(Inquiry inquiry) {
        return this.searchAndAsync(inquiry, "");
    }

    public Future<JsonObject> searchAndAsync(Inquiry inquiry, String pojo) {
        JsonObject result = new JsonObject();
        return this.searchDirect(inquiry, Operator.AND).compose(array -> Ux.thenJsonMore(array.getList(), pojo)).compose(array -> {
            result.put("list", array);
            return this.countSearchAsync(inquiry, Operator.AND);
        }).compose(count -> {
            result.put("count", count);
            return Future.succeededFuture((Object)result);
        });
    }

    public <T> Future<List<T>> searchAndListAsync(Inquiry inquiry) {
        return this.searchAsync(inquiry, Operator.AND);
    }

    public <T> Future<List<T>> searchOrListAsync(Inquiry inquiry) {
        return this.searchAsync(inquiry, Operator.OR);
    }

    private Future<JsonArray> searchDirect(Inquiry inquiry, Operator operator) {
        return this.searchAsync(inquiry, operator).compose(list -> {
            if (null == inquiry.getProjection()) {
                return Ux.thenJsonMore(list);
            }
            return Ux.thenJsonMore(list).compose(array -> Uarr.create((JsonArray)array).remove(inquiry.getProjection().toArray(new String[0])).toFuture());
        });
    }

    private <T> Future<Integer> countSearchAsync(Inquiry inquiry, Operator operator) {
        Criteria criteria = inquiry.getCriteria();
        Function<DSLContext, Integer> function = dslContext -> null == criteria ? dslContext.fetchCount(this.vertxDAO.getTable()) : dslContext.fetchCount(this.vertxDAO.getTable(), UxJooq.transform(criteria.toJson(), operator));
        return Async.toFuture(this.vertxDAO.executeAsync(function));
    }

    public <T> Future<List<T>> searchAsync(Inquiry inquiry, Operator operator) {
        Function<DSLContext, List> function = dslContext -> {
            SelectWhereStep started = dslContext.selectFrom(this.vertxDAO.getTable());
            SelectConditionStep conditionStep = null;
            if (null != inquiry.getCriteria()) {
                Condition condition = UxJooq.transform(inquiry.getCriteria().toJson(), operator);
                conditionStep = started.where(new Condition[]{condition});
            }
            SelectSeekStepN selectStep = null;
            if (null != inquiry.getSorter()) {
                JsonObject sorter = inquiry.getSorter().toJson();
                ArrayList<SortField> orders = new ArrayList<SortField>();
                for (String field : sorter.fieldNames()) {
                    boolean asc = sorter.getBoolean(field);
                    orders.add(asc ? DSL.field((String)field).asc() : DSL.field((String)field).desc());
                }
                selectStep = null == conditionStep ? started.orderBy(orders) : conditionStep.orderBy(orders);
            }
            SelectWithTiesAfterOffsetStep pagerStep = null;
            if (null != inquiry.getPager()) {
                Pager pager = inquiry.getPager();
                pagerStep = null == selectStep && null == conditionStep ? started.offset(pager.getStart()).limit(pager.getEnd()) : (null == selectStep ? conditionStep.offset(pager.getStart()).limit(pager.getEnd()) : selectStep.offset(pager.getStart()).limit(pager.getEnd()));
            }
            if (null != pagerStep) {
                return pagerStep.fetch(this.vertxDAO.mapper());
            }
            if (null != selectStep) {
                return selectStep.fetch(this.vertxDAO.mapper());
            }
            if (null != conditionStep) {
                return conditionStep.fetch(this.vertxDAO.mapper());
            }
            return started.fetch(this.vertxDAO.mapper());
        };
        return Async.toFuture(this.vertxDAO.executeAsync(function));
    }

    public static Condition transform(JsonObject filters, Operator operator) {
        Condition condition = null;
        for (String field : filters.fieldNames()) {
            String key = UxJooq.getKey(field);
            String targetField = field.split(",")[0];
            Object[] value = filters.getValue(field);
            BiFunction fun = (BiFunction)OPS.get(key);
            if (Types.isJArray((Object)value)) {
                value = ((JsonArray)value).getList().toArray();
            }
            Condition item = (Condition)fun.apply(targetField.trim(), value);
            condition = UxJooq.opCond(condition, item, Operator.AND);
        }
        LOGGER.info("[ ZERO ] ( Jooq -> fetchAndAsync ) Parsed result is condition = {0}", new Object[]{condition});
        return condition;
    }

    private static String getKey(String field) {
        if (!field.contains(",")) {
            return "=";
        }
        String opStr = field.split(",")[1];
        return StringUtil.isNil((String)opStr) ? "=" : opStr.trim().toLowerCase();
    }

    private static Condition opIn(String field, Object value) {
        return UxJooq.opCond(value, Operator.OR, arg_0 -> ((Field)DSL.field((String)field)).eq(arg_0));
    }

    private static Condition opNotIn(String field, Object value) {
        return UxJooq.opCond(value, Operator.OR, arg_0 -> ((Field)DSL.field((String)field)).ne(arg_0));
    }

    private static Condition opCond(Object value, Operator operator, Function<Object, Condition> condFun) {
        Condition condition = null;
        Collection values = Types.toCollection((Object)value);
        if (null != values) {
            for (Object item : values) {
                Condition itemCond = condFun.apply(item);
                condition = UxJooq.opCond(condition, itemCond, operator);
            }
        }
        return condition;
    }

    private static Condition opCond(Condition left, Condition right, Operator operator) {
        if (null == left || null == right) {
            if (null == left && null != right) {
                return right;
            }
            return null;
        }
        if (Operator.AND == operator) {
            return left.and(right);
        }
        return left.or(right);
    }
}

