/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.micro.config;

import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.Ensurer;
import io.vertx.zero.atom.Ruler;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.exception.demon.ServerConfigException;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.micro.config.HttpServerVisitor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DynamicVisitor
extends HttpServerVisitor {
    private static final Annal LOGGER = Annal.get(DynamicVisitor.class);
    private final transient Node<JsonObject> NODE = Node.infix((String)"server");
    private transient ServerType type;

    @Override
    public ConcurrentMap<Integer, HttpServerOptions> visit(String ... key) throws ZeroException {
        Ensurer.eqLength(this.getClass(), (int)1, (Object[])key);
        JsonObject data = (JsonObject)this.NODE.read();
        Fn.flingZero((null == data || !data.containsKey("server") ? 1 : 0) != 0, (Annal)LOGGER, ServerConfigException.class, (Object[])new Object[]{this.getClass(), null == data ? null : data.encode()});
        this.type = ServerType.valueOf((String)key[0]);
        return this.visit(data.getJsonArray("server"));
    }

    private ConcurrentMap<Integer, HttpServerOptions> visit(JsonArray serverData) throws ZeroException {
        this.getLogger().info("[ ZERO ] The raw data ( node = {0}, type = {1} ) before validation is {2}.", new Object[]{"server", this.type, serverData.encode()});
        Ruler.verify((String)"server", (JsonArray)serverData);
        ConcurrentHashMap<Integer, HttpServerOptions> map = new ConcurrentHashMap<Integer, HttpServerOptions>();
        this.extract(serverData, map);
        this.getLogger().info("[ ZERO ] ( node = {0}, type = {1} ) filtered configuration port set = {2}.", new Object[]{"server", this.type, map.keySet()});
        return map;
    }

    @Override
    protected boolean isServer(JsonObject item) {
        return null != this.type && this.type.match(item.getString("type"));
    }
}

