/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.micro.config;

import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.Ensurer;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.zero.atom.Ruler;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.marshal.Visitor;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.marshal.node.ZeroUniform;

public class CircuitVisitor
implements Visitor<CircuitBreakerOptions> {
    private static final Annal LOGGER = Annal.get(CircuitVisitor.class);
    private final transient Node<JsonObject> node = (Node)Instance.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private static final String CIRCUIT = "circuit";

    public CircuitBreakerOptions visit(String ... key) throws ZeroException {
        Ensurer.eqLength(this.getClass(), (int)0, (Object[])key);
        JsonObject data = (JsonObject)this.node.read();
        JsonObject config = (JsonObject)Fn.getSemi((data.containsKey(CIRCUIT) && null != data.getValue(CIRCUIT) ? 1 : 0) != 0, (Annal)LOGGER, () -> data.getJsonObject(CIRCUIT), JsonObject::new);
        return this.visit(config);
    }

    private CircuitBreakerOptions visit(JsonObject data) throws ZeroException {
        LOGGER.info("[ ZERO ] The raw data ( node = {0}, type = {1} ) before validation is {2}.", new Object[]{CIRCUIT, "Circuit", data.encode()});
        Ruler.verify((String)CIRCUIT, (JsonObject)data);
        return new CircuitBreakerOptions(data);
    }
}

