/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.router;

import io.reactivex.Observable;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.up.atom.secure.Cliff;
import io.vertx.up.func.Fn;
import io.vertx.up.rs.Axis;
import io.vertx.up.rs.router.Pool;
import io.vertx.up.web.ZeroAnno;
import io.vertx.up.web.failure.AuthenticateEndurer;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class WallAxis
implements Axis<Router> {
    private final transient Vertx vertx;
    private static final Set<Cliff> WALLS = ZeroAnno.getWalls();

    public WallAxis(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public void mount(Router router) {
        router.route().order(1600000).handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        Pool.WALL_MAP.forEach((path, cliffes) -> {
            AuthHandler handler = this.create((Set<Cliff>)cliffes);
            if (null != handler) {
                router.route(path).order(1800000).handler((Handler)handler).failureHandler(AuthenticateEndurer.create());
            }
        });
    }

    private AuthHandler create(Set<Cliff> cliffes) {
        AuthHandler resultHandler = null;
        if (1 < cliffes.size()) {
            ChainAuthHandler chain = ChainAuthHandler.create();
            Observable.fromIterable(cliffes).filter(Objects::nonNull).map(this::get).filter(Objects::nonNull).subscribe(arg_0 -> ((ChainAuthHandler)chain).append(arg_0));
            resultHandler = chain;
        } else if (!cliffes.isEmpty()) {
            Cliff cliff = cliffes.iterator().next();
            resultHandler = this.get(cliff);
        }
        return resultHandler;
    }

    private AuthHandler get(Cliff cliff) {
        return (AuthHandler)Fn.getJvm(() -> {
            JsonObject config = cliff.getConfig();
            config = null == config ? new JsonObject() : config;
            Object reference = cliff.getAuthorizer().getAuthenticate().invoke(cliff.getProxy(), config);
            return null == reference ? null : (AuthHandler)reference;
        }, (Object[])new Object[]{cliff, cliff.getProxy(), cliff.getAuthorizer(), cliff.getAuthorizer().getAuthenticate()});
    }

    static {
        WALLS.forEach(wall -> {
            if (!Pool.WALL_MAP.containsKey(wall.getPath())) {
                Pool.WALL_MAP.put(wall.getPath(), new TreeSet());
            }
            ((Set)Pool.WALL_MAP.get(wall.getPath())).add(wall);
        });
    }
}

