/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.follow;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.up.aiki.Ux;
import io.vertx.up.atom.Envelop;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.follow.Invoker;
import io.vertx.up.micro.follow.InvokerUtil;
import io.vertx.up.micro.ipc.client.TunnelClient;
import io.vertx.up.tool.Jackson;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.tool.mirror.Types;
import java.lang.reflect.Method;

public class AsyncInvoker
implements Invoker {
    private static final Annal LOGGER = Annal.get(AsyncInvoker.class);

    @Override
    public void ensure(Class<?> returnType, Class<?> paramCls) {
        boolean valid = Void.TYPE != returnType && Void.class != returnType;
        InvokerUtil.verify(!valid, returnType, paramCls, this.getClass());
    }

    @Override
    public void invoke(Object proxy, Method method, Message<Envelop> message) {
        Envelop envelop = (Envelop)message.body();
        Class<?> argType = method.getParameterTypes()[0];
        Class<?> returnType = method.getReturnType();
        LOGGER.info("[ ZERO ] ( Invoker ) Invoker = {0}, ReturnType = {1}, Rpc Continue: {2}.", new Object[]{this.getClass(), returnType, false});
        Class<?> tCls = returnType.getComponentType();
        if (Envelop.class == tCls) {
            Future result = (Future)Instance.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{envelop});
            result.setHandler(item -> message.reply(item.result()));
        } else {
            Object reference = envelop.data();
            Object arguments = Jackson.deserialize((String)Types.toString(reference), argType);
            Future tResult = (Future)Instance.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{arguments});
            tResult.setHandler(Ux.toHandler(message));
        }
    }

    @Override
    public void next(Object proxy, Method method, Message<Envelop> message, Vertx vertx) {
        Envelop envelop = (Envelop)message.body();
        Class<?> argType = method.getParameterTypes()[0];
        Class<?> returnType = method.getReturnType();
        LOGGER.info("[ ZERO ] ( Invoker ) Invoker = {0}, ReturnType = {1}, Rpc Continue: {2}.", new Object[]{this.getClass(), returnType, true});
        Class<?> tCls = returnType.getComponentType();
        if (Envelop.class == tCls) {
            Future result = (Future)Instance.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{envelop});
            result.compose(item -> TunnelClient.create(this.getClass()).connect(vertx).connect(method).send((Envelop)item)).setHandler(Ux.toHandler(message));
        } else {
            Object reference = envelop.data();
            Object arguments = Jackson.deserialize((String)Types.toString(reference), argType);
            Future future = (Future)Instance.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{arguments});
            future.compose(item -> TunnelClient.create(this.getClass()).connect(vertx).connect(method).send(Ux.to(item))).compose(item -> Future.succeededFuture((Object)Ux.to(item))).setHandler(Ux.toHandler(message));
        }
    }
}

