/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.discovery;

import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.up.atom.Envelop;
import io.vertx.up.exception._404ServiceNotFoundException;
import io.vertx.up.exception._405MethodForbiddenException;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.matcher.Arithmetic;
import io.vertx.up.micro.matcher.CommonArithmetic;
import io.vertx.up.rs.hunt.Answer;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.zero.marshal.Visitor;
import io.vertx.zero.micro.config.CircuitVisitor;
import java.util.List;

public class ServiceJet {
    private static final Annal LOGGER = Annal.get(ServiceJet.class);
    private static final Visitor<CircuitBreakerOptions> VISITOR = (Visitor)Instance.singleton(CircuitVisitor.class, (Object[])new Object[0]);
    private static CircuitBreakerOptions OPTIONS;
    private transient ServiceDiscovery discovery;
    private transient CircuitBreaker breaker;
    private final transient Arithmetic arithmetic = (Arithmetic)Instance.singleton(CommonArithmetic.class, (Object[])new Object[0]);
    private final transient HttpServerOptions options;

    public static ServiceJet create(HttpServerOptions options) {
        return new ServiceJet(options);
    }

    private ServiceJet(HttpServerOptions options) {
        this.options = options;
    }

    public ServiceJet connect(Vertx vertx) {
        this.discovery = ServiceDiscovery.create((Vertx)vertx);
        String name = this.options.getHost() + this.options.getPort();
        this.breaker = CircuitBreaker.create((String)name, (Vertx)vertx, (CircuitBreakerOptions)OPTIONS);
        return this;
    }

    public Handler<RoutingContext> handle() {
        return context -> this.breaker.execute(future -> this.getEndPoints().setHandler(res -> {
            if (res.succeeded()) {
                List records = (List)res.result();
                Record hitted = this.arithmetic.search(records, (RoutingContext)context);
                if (null == hitted) {
                    this.reply404Error((RoutingContext)context);
                } else {
                    ServiceReference reference = this.discovery.getReference(hitted);
                    this.doRequest((RoutingContext)context, reference);
                }
                future.complete();
            } else {
                future.fail(res.cause());
            }
        }));
    }

    private void doRequest(RoutingContext context, ServiceReference reference) {
        Fn.safeJvm(() -> {
            HttpMethod method = context.request().method();
            String targetUri = this.redirectUri(context);
            HttpClient client = (HttpClient)reference.getAs(HttpClient.class);
            HttpClientRequest request = client.request(method, targetUri, response -> response.bodyHandler(handler -> {
                if (404 == response.statusCode()) {
                    this.reply405Error(context);
                } else {
                    this.replySuccess(context.response(), (HttpClientResponse)response, (Buffer)handler);
                }
            }));
            request.headers().setAll(context.request().headers());
            if (null == context.getBody()) {
                request.end();
            } else {
                request.end(context.getBody());
            }
        }, (Annal)LOGGER);
    }

    private void replySuccess(HttpServerResponse response, HttpClientResponse clientResponse, Buffer buffer) {
        String data = buffer.toString();
        response.headers().setAll(clientResponse.headers());
        response.setStatusCode(clientResponse.statusCode());
        response.setStatusMessage(clientResponse.statusMessage());
        response.write(data);
        response.end();
    }

    private String redirectUri(RoutingContext event) {
        StringBuilder uri = new StringBuilder();
        uri.append(event.request().path());
        if (null != event.request().query()) {
            uri.append(String.valueOf("?")).append(event.request().query());
        }
        return uri.toString();
    }

    private void reply404Error(RoutingContext context) {
        HttpServerRequest request = context.request();
        _404ServiceNotFoundException exception = new _404ServiceNotFoundException(this.getClass(), request.uri(), request.method());
        Answer.reply(context, Envelop.failure(exception));
    }

    private void reply405Error(RoutingContext context) {
        HttpServerRequest request = context.request();
        _405MethodForbiddenException exception = new _405MethodForbiddenException(this.getClass(), request.method(), request.uri());
        Answer.reply(context, Envelop.failure(exception));
    }

    private Future<List<Record>> getEndPoints() {
        Future future = Future.future();
        this.discovery.getRecords(record -> record.getType().equals("http-endpoint"), future.completer());
        return future;
    }

    static {
        Fn.flingUp(() -> {
            if (null == OPTIONS) {
                OPTIONS = (CircuitBreakerOptions)VISITOR.visit(new String[0]);
            }
        }, (Annal)LOGGER);
    }
}

