/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.atom.agent;

import io.vertx.up.atom.agent.Event;
import io.vertx.up.func.Fn;
import io.vertx.up.rs.Filler;
import io.vertx.up.tool.Statute;
import io.vertx.up.tool.mirror.Instance;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public class Depot
implements Serializable {
    private List<Class<?>> paramTypes = new ArrayList();
    private List<Object> paramValues = new ArrayList<Object>();
    private final List<String> paramNames = new ArrayList<String>();
    private final Event event;
    private final List<Class<? extends Annotation>> paramAnnos = new ArrayList<Class<? extends Annotation>>();

    public static Depot create(Event event) {
        return new Depot(event);
    }

    private Depot(Event event) {
        this.initTypes(event.getAction());
        this.initAnnotationsWithName(event.getAction());
        this.event = event;
    }

    private void initTypes(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        this.paramTypes = Arrays.asList(paramTypes);
    }

    private void initAnnotationsWithName(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        Fn.itArray((Object[])annotations, (annotationArr, index) -> {
            Annotation annotation = this.findAnnotation((Annotation[])annotationArr);
            Class<? extends Annotation> annoCls = null == annotation ? null : annotation.annotationType();
            this.paramAnnos.add(annoCls);
            if (null != annoCls) {
                if (Filler.NO_VALUE.contains(annoCls)) {
                    this.paramNames.add("$$DIRECT$$");
                } else {
                    String name = (String)Instance.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
                    this.paramNames.add(name);
                }
            } else {
                this.paramNames.add("$$IGNORE$$");
            }
            this.paramValues.add(null);
        });
    }

    private Annotation findAnnotation(Annotation[] annotations) {
        Annotation annotationCls = null;
        for (Annotation annotation : annotations) {
            if (!Filler.PARAMS.containsKey(annotation.annotationType())) continue;
            annotationCls = annotation;
        }
        return annotationCls;
    }

    public ConcurrentMap<String, Class<?>> getTypes() {
        return Statute.zipper(this.paramNames, this.paramTypes);
    }

    public ConcurrentMap<String, Object> getValues() {
        return Statute.zipper(this.paramNames, this.paramValues);
    }

    public ConcurrentMap<String, Class<? extends Annotation>> getAnnotations() {
        return Statute.zipper(this.paramNames, this.paramAnnos);
    }

    public void setParamValues(Object[] parameters) {
        this.paramValues = Arrays.asList(parameters);
    }

    public Event getEvent() {
        return this.event;
    }
}

